/* -*- Mode: C; c-file-style: "gnu"; indent-tabs-mode:nil -*- */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "runtimeint.h"
#include "arch.h"

#define MYLOG "Thread"

/* XXX Is this the correct implementation?  Stolen from kaffe 0.10.0 */
void
suspend_thread(japhar_object* thread_jobj, HungryEnv *henv)
{
  HVM_MonitorEnter(henv, thread_jobj);
#if WITH_JVMDI
  henv->current_state = STATE_SUSPENDED;
#endif
  HVM_MonitorWait(henv, thread_jobj, PR_INTERVAL_NO_TIMEOUT);
  HVM_MonitorExit(henv, thread_jobj);
}

/* XXX Is this the correct implementation?  Stolen from kaffe 0.10.0 */
void
resume_thread(japhar_object* thread_jobj, HungryEnv *henv)
{
  HVM_MonitorEnter(henv, thread_jobj);

  /* XXX How do we make sure that we start the one which is suspended? */
  HVM_MonitorNotifyOne(henv, thread_jobj);
#if WITH_JVMDI
  henv->current_state = STATE_RUNNING;
#endif
  HVM_MonitorExit(henv, thread_jobj);
}

static PRUintn ENV_INDEX;

void
HVM_ThreadSetEnv(HungryEnv* henv)
{
  static int index_init = 0;
  if (0 == index_init)
    {
      index_init = 1;
      PR_NewThreadPrivateIndex(&ENV_INDEX, NULL);
    }

  PR_SetThreadPrivate(ENV_INDEX, henv);
}

HungryEnv*
HVM_ThreadGetEnv()
{
  return (HungryEnv*)PR_GetThreadPrivate(ENV_INDEX);
}
