/* -*- Mode: C; c-file-style: "gnu"; indent-tabs-mode:nil -*-
   monitors.c -- api for locking/unlocking objects.
   Created: Chris Toshok <toshok@hungry.com>, 24-Dec-1999
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "runtimeint.h"

PR_IMPLEMENT( PRBool )
HVM_MonitorEnter(HungryEnv *henv, japhar_object *obj)
{
  return (PR_CEnterMonitor(obj) != NULL);
}

PR_IMPLEMENT( PRBool )
HVM_MonitorExit(HungryEnv *henv, japhar_object *obj)
{
  return (PR_CExitMonitor(obj) != PR_FAILURE);
}

PR_EXTERN( PRBool )
HVM_MonitorWait(HungryEnv *henv, japhar_object *obj, PRIntervalTime timeout)
{
  return (PR_CWait(obj, timeout) != PR_FAILURE);
}

PR_EXTERN( PRBool )
HVM_MonitorNotifyOne(HungryEnv *henv, japhar_object *obj)
{
  return (PR_CNotify(obj) != PR_FAILURE);
}

PR_EXTERN( PRBool )
HVM_MonitorNotifyAll(HungryEnv *henv, japhar_object *obj)
{
  return (PR_CNotify(obj) != PR_FAILURE);
}
