/* -*- Mode: C; c-file-style: "gnu"; indent-tabs-mode:nil -*-
   alloc.c -- our wrappers with exceptions for *alloc(), free() and strdup()
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1998-07-16
*/
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "runtimeint.h"

#include "nspr.h"
#include "plstr.h"

void*
jmalloc(HungryEnv *henv, PRSize size)
{
  void *ptr = HVM_Malloc(size);

  if (NULL == ptr)
    HVM_ExceptionThrow(henv, java_lang_OutOfMemoryError, "jmalloc() failed");

  return ptr;
}

void*
jcalloc(HungryEnv *henv, PRSize nmemb, PRSize size)
{
  void *ptr = HVM_Calloc(nmemb, size);

  if (NULL == ptr)
    HVM_ExceptionThrow(henv, java_lang_OutOfMemoryError, "jcalloc() failed");

  return ptr;
}

void
jfree(HungryEnv *henv, void *ptr)
{
  if (NULL == ptr)
    return; /* XXX Should this throw NullPointerException? [pere] */
  HVM_Free (ptr);
}

void*
jrealloc(HungryEnv *henv, void *ptr, PRSize size)
{
  void *retptr;

  if (size == 0)
    return NULL; /* XXX Should this throw NullPointerException? [pere] */

  retptr = HVM_Realloc(ptr, size);

  if (NULL == retptr)
    HVM_ExceptionThrow(henv, java_lang_OutOfMemoryError, "jrealloc() failed");

  return retptr;
}

char*
jstrdup(HungryEnv *henv, const char *str)
{
  char *ptr;
  if (NULL == str)
    {
      HVM_ExceptionThrow(henv, java_lang_NullPointerException, "jstrdup() failed");
      return NULL;
    }

  ptr = HVM_Strdup (str);

  if (NULL == ptr)
    HVM_ExceptionThrow(henv, java_lang_OutOfMemoryError, "jstrdup() failed");

  return ptr;
}
