/* -*- Mode: C; c-file-style: "gnu" -*-
   japharJVMPlugin.h -- japhar's mozilla java runtime support
   Created: Chris Toshok <toshok@hungry.com>, 8-Aug-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _japharJVMPlugin_h
#define _japharJVMPlugin_h

/* japhar headers */
#include "jni.h"
#include "arch.h"
#include "japharJVMConsole.h"

/* nscp headers */
#include "nsplugin.h"
#include "nsIJVMConsole.h"
#include "nsIJVMManager.h"
#include "nsIJVMPlugin.h"
#include "nsIJVMPluginInstance.h"
#include "nsIJVMPluginTagInfo.h"
#include "nsISymantecDebugManager.h"
#include "nsISymantecDebugger.h"
#include "nsIThreadManager.h"
#include "nsIEventHandler.h"

// {b01abb1c-1dd1-11b2-a651-d41285ecdaa7}
#define JAPHAR_PLUGIN_CID { 0xb01abb1c, 0x1dd1, 0x11b2, {0xa6, 0x51, 0xd4, 0x12, 0x85, 0xec, 0xda, 0xa7 } }

#define JAPHAR_MIME_DESC NS_JVM_MIME_TYPE ":class:Japhar OJI Plugin"

class japharJVMPlugin : public virtual nsIJVMPlugin, public virtual nsIPlugin {
public:

  japharJVMPlugin();

  JavaVM *GetRunningVM(void);

  /////////////////////////////////////////////////
  // nsISupports
  /////////////////////////////////////////////////
  NS_DECL_ISUPPORTS
    
  /////////////////////////////////////////////////
  // nsIFactory
  /////////////////////////////////////////////////
    
  NS_IMETHOD CreateInstance(nsISupports *aOuter,
			    REFNSIID aIID,
			    void **aResult);

  NS_IMETHOD LockFactory(PRBool aLock);
  
  /////////////////////////////////////////////////
  // nsIPlugin
  /////////////////////////////////////////////////
  
  /**
   * Creates a new plugin instance, based on a MIME type. This
   * allows different impelementations to be created depending on
   * the specified MIME type.
   */
  NS_IMETHOD CreatePluginInstance(nsISupports *aOuter, REFNSIID aIID, 
				  const char* aPluginMIMEType,
				  void **aResult);

  /**
   * Initializes the plugin and will be called before any new instances are
   * created. It is passed browserInterfaces on which QueryInterface
   * may be used to obtain an nsIPluginManager, and other interfaces.
   *
   * @param browserInterfaces - an object that allows access to other browser
   * interfaces via QueryInterface
   * @result - NS_OK if this operation was successful
   */
  NS_IMETHOD
  Initialize();

  /**
   * Called when the browser is done with the plugin factory, or when
   * the plugin is disabled by the user.
   *
   * (Corresponds to NPP_Shutdown.)
   *
   * @result - NS_OK if this operation was successful
   */
  NS_IMETHOD
  Shutdown(void);
  
  /**
   * Returns the MIME description for the plugin. The MIME description 
   * is a colon-separated string containg the plugin MIME type, plugin
   * data file extension, and plugin name, e.g.:
   *
   * "application/x-simple-plugin:smp:Simple LiveConnect Sample Plug-in"
   *
   * (Corresponds to NPP_GetMIMEDescription.)
   *
   * @param resultingDesc - the resulting MIME description 
   * @result - NS_OK if this operation was successful
   */
  NS_IMETHOD
  GetMIMEDescription(const char* *resultingDesc);
  
  /**
   * Returns the value of a variable associated with the plugin.
   *
   * (Corresponds to NPP_GetValue.)
   *
   * @param variable - the plugin variable to get
   * @param value - the address of where to store the resulting value
   * @result - NS_OK if this operation was successful
   */
  NS_IMETHOD
  GetValue(nsPluginVariable variable, void *value);
  
  /////////////////////////////////////////////////
  // nsIJVMPlugin
  /////////////////////////////////////////////////
  
  // Causes the JVM to append a new directory to its classpath.
  // If the JVM doesn't support this operation, an error is returned.
  NS_IMETHOD
  AddToClassPath(const char* dirPath);
  
  // Causes the JVM to remove a directory from its classpath.
  // If the JVM doesn't support this operation, an error is returned.
  NS_IMETHOD
  RemoveFromClassPath(const char* dirPath);
  
  // Returns the current classpath in use by the JVM.
  NS_IMETHOD
  GetClassPath(const char* *result);
  
  NS_IMETHOD
  GetJavaWrapper(JNIEnv* jenv, jint obj, jobject *jobj);
  
  /**
   * This creates a new secure communication channel with Java. The second parameter,
   * nativeEnv, if non-NULL, will be the actual thread for Java communication.
   * Otherwise, a new thread should be created.
   * @param	proxyEnv		the env to be used by all clients on the browser side
   * @return	outSecureEnv	the secure environment used by the proxyEnv
   */
  NS_IMETHOD
  CreateSecureEnv(JNIEnv* proxyEnv, nsISecureEnv* *outSecureEnv);
  
  /**
   * Gives time to the JVM from the main event loop of the browser. This is
   * necessary when there aren't any plugin instances around, but Java threads exist.
   */
  NS_IMETHOD
  SpendTime(PRUint32 timeMillis);

 protected:
  JavaVM *_vm;
  JNIEnv *_env;
  int _env_refcnt;
  PRMonitor *_factory_monitor;

  nsISupports *_pluginman; /* our nsIPluginManager */
  nsISupports *_console; /* our console interface */
  
  nsresult StartupJVM(void);
};

#endif /* _japharJVMPlugin_h */
