/* -*- Mode: C; c-file-style: "gnu" -*-
   japharJVMPlugin.cpp -- japhar's mozilla java runtime support
   Created: Chris Toshok <toshok@hungry.com>, 7-Apr-1999.
 */

/* somewhat culled from netscape's MRJ plugin */

#include "config.h"
#include "jni.h"

#include <stdio.h>

void
Java_netscape_javascript_JSObject_initClass(JNIEnv *env,
					    jclass cls)
{
  printf ("+Java_netscape_javascript_JSObject_initClass\n");
}

/**
 * Retrieves a named member of a JavaScript object.
 * Equivalent to "this.<i>name</i>" in JavaScript.
 *
 * public native Object        getMember(String name);
 */
jobject
Java_netscape_javascript_JSObject_getMember(JNIEnv *env,
					    jobject jsobj,
					    jstring name)
{
  printf ("+Java_netscape_javascript_JSObject_getMember\n");
}

/**
 * Retrieves an indexed member of a JavaScript object.
 * Equivalent to "this[<i>index</i>]" in JavaScript.
 *
 * public native Object        getSlot(int index);
 */
jobject
Java_netscape_javascript_JSObject_getSlot(JNIEnv *env,
					  jobject jsobj,
					  jint index)
{
  printf ("+Java_netscape_javascript_JSObject_getSlot\n");
}

/**
 * Sets a named member of a JavaScript object.
 * Equivalent to "this.<i>name</i> = <i>value</i>" in JavaScript.
 *
 * public native void          setMember(String name, Object value);
 */
void
Java_netscape_javascript_JSObject_setMember(JNIEnv *env,
					    jobject jsobj,
					    jstring name,
					    jobject value)
{
  printf ("+Java_netscape_javascript_JSObject_setMember\n");
}

/**
 * Sets an indexed member of a JavaScript object.
 * Equivalent to "this[<i>index</i>] = <i>value</i>" in JavaScript.
 *
 * public native void          setSlot(int index, Object value);
 */
void
Java_netscape_javascript_JSObject_setSlot(JNIEnv *env,
					  jobject jsobj,
					  jint index,
					  jobject value)
{
  printf ("+Java_netscape_javascript_JSObject_setSlot\n");
}

/**
 * Removes a named member of a JavaScript object.
 *
 * public native void          removeMember(String name);
 */
void
Java_netscape_javascript_JSObject_removeMember(JNIEnv *env,
					       jobject jsobj,
					       jstring name)
{
  printf ("+Java_netscape_javascript_JSObject_removeMember\n");
}

/**
 * Calls a JavaScript method.
 * Equivalent to "this.<i>methodName</i>(<i>args</i>[0], <i>args</i>[1], ...)" in JavaScript. 
 *
 * public native Object        call(String methodName, Object args[]);
 */
jobject
Java_netscape_javascript_JSObject_call(JNIEnv *env,
				       jobject jsobj,
				       jstring methodName,
				       jobjectArray args)
{
  printf ("+Java_netscape_javascript_JSObject_call\n");
}

/**
 * Evaluates a JavaScript expression. The expression is a string
 * of JavaScript source code which will be evaluated in the context
 * given by "this".
 *
 * public native Object        eval(String s);
 */
jobject
Java_netscape_javascript_JSObject_eval(JNIEnv *env,
				       jobject jsobj,
				       jstring s)
{
  printf ("+Java_netscape_javascript_JSObject_eval\n");
}

/**
 * Converts a JSObject to a String.
 *
 * public native String        toString();
 */
jstring
Java_netscape_javascript_JSObject_toString(JNIEnv *env,
					   jobject jsobj)
{
  printf ("+Java_netscape_javascript_JSObject_toString\n");
}

/**
 * get a JSObject for the window containing the given applet
 *
 * public static native JSObject       getWindow(Applet applet);
 */
jobject
Java_netscape_javascript_JSObject_getWindow(JNIEnv *env,
					    jclass cls,
					    jobject applet)
{
  printf ("+Java_netscape_javascript_JSObject_getWindow\n");
}

/**
 * Finalization decrements the reference count on the corresponding
 * JavaScript object.
 *
 * protected native void       finalize(); 
 */
void
Java_netscape_javascript_JSObject_finalize(JNIEnv *env,
					   jobject jsobj)
{
  printf ("+Java_netscape_javascript_JSObject_finalize\n");
}

/**
 * Override java.lang.Object.equals() because identity is not preserved
 * with instances of JSObject.
 * public native boolean equals(Object obj);
 */
jboolean
Java_netscape_javascript_JSObject_equals(JNIEnv *env,
					 jobject jsobj,
					 jobject obj)
{
  printf ("+Java_netscape_javascript_JSObject_equals\n");
}
