/* -*- Mode: C; c-file-style: "gnu" -*-
   sysresources.c -- native methods for sun.net.www.protocol.systemresource.SystemResourceManager.
   Created: Chris Toshok <toshok@hungry.com>, 8-Feb-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include "jniint.h"
#include "zipfile.h"

#include <fcntl.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef HAVE_IO_H
#  include <io.h>
#endif

extern PRLogModuleInfo* nativeLm;

JNIEXPORT jstring JNICALL
Java_sun_net_www_protocol_systemresource_SystemResourceManager_getEntryFromKey(JNIEnv *env,
									       jclass cls,
									       jint key)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  HungryVM *hvm = henv->vm;
  HVMClasspathEntry *entries = hvm->_cp->entries;
  int num_entries = hvm->_cp->num_entries;
  jstring entry;

  if (key >= num_entries)
    {
      return NULL;
    }
  else
    {
      entry = (*env)->NewStringUTF(env, entries[key].path);
	  
      return entry;
    }
}

JNIEXPORT jbyteArray JNICALL
Java_sun_net_www_protocol_systemresource_SystemResourceManager_getZipResourceByteArray(JNIEnv *env,
										       jclass cls,
										       jstring base,
										       jstring member)
{
  const jbyte *base_bytes = (*env)->GetStringUTFChars(env, base, NULL);
  const jbyte *member_bytes = (*env)->GetStringUTFChars(env, member, NULL);
  jbyteArray array = NULL;
  struct ZipFile zip;
  ZipDirectory *dir;
  int j;
  
  PR_LOG (nativeLm, PR_LOG_DEBUG,
	  ("Trying to load member '%s' from base zip file '%s'\n",
	   member_bytes, base_bytes));

  /* XXX O_BINARY? */
  zip.fd = PR_Open((char*)base_bytes, O_RDONLY, 0);
  
  if (NULL == zip.fd) goto leave;
  if (read_zip_archive(&zip) != 0)
    {
      PR_Close(zip.fd);
      goto leave;
    }
  
  dir = (ZipDirectory*)zip.central_directory;
  
  for (j = 0; j < zip.count; j ++, dir = ZIPDIR_NEXT(dir))
    {
      if (!strcmp((const char*)member_bytes, ZIPDIR_FILENAME(dir)))
	{
	  char *buf;
	  int len;
	  int malloced;
	  array = (*env)->NewByteArray(env, dir->uncompressed_size);
		  
	  get_zipfile_entry(&zip, dir,
			    &buf, &len,
			    &malloced);
		
	  (*env)->SetByteArrayRegion(env, array, 0, len - 1, (jbyte*)buf);
		  
	  free_zipfile_entry(dir, buf, len, malloced);

	  break;
	}
    }
  
 leave:
  (*env)->ReleaseStringUTFChars(env, base, base_bytes);
  (*env)->ReleaseStringUTFChars(env, member, member_bytes);
  if (!array) PR_LOG (nativeLm, PR_LOG_DEBUG, ("returning NULL\n"));
  return array;
}

JNIEXPORT jboolean JNICALL
Java_sun_net_www_protocol_systemresource_SystemResourceManager_validateSystemResource(JNIEnv *env,
										      jclass cls,
										      jboolean foo,
										      jstring base,
										      jstring member)
{
#if 0
  const jbyte *base_str;
  jboolean ret_val = JNI_FALSE;

  base_str = (*env)->GetStringUTFChars(env, base, NULL);

  if (!strcmp((const char*)base_str, CLASSZIP))
    ret_val = JNI_TRUE;

  (*env)->ReleaseStringUTFChars(env, base, base_str);

  return ret_val;
#else
  /* always return true. */
  return JNI_TRUE;
#endif
}
