/* -*- Mode: C; c-file-style: "gnu" -*-
   window.c -- native methods for sun/awt/motif/MWindowPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"

#include "common.h"
#include <Xm/Xm.h>

#include <assert.h>
#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_create(JNIEnv *env,
				      jobject peer,
				      jobject parent_peer)
{
  Widget window_widget, parent_widget;

  parent_widget = get_component_widget(env, parent_peer);

  LOCK_AWT();
  window_widget = XtCreateWidget("dialog",
				 overrideShellWidgetClass,
				 parent_widget,
				 NULL, 0);

  inherit_background_from(parent_widget, window_widget);

  UNLOCK_AWT();

  set_component_widget(env, peer, window_widget);
}

extern JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_pShow(JNIEnv *env,
				     jobject peer)
{
  Widget window_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtPopup(window_widget, XtGrabNone);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_pHide(JNIEnv *env,
				     jobject peer)
{
  Widget window_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtPopdown(window_widget);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_pReshape(JNIEnv *env,
					jobject peer,
					jint x,
					jint y,
					jint width,
					jint height)
{
  Widget widget = get_component_widget(env, peer);
  int rootx, rooty;
  Window child;

  LOCK_AWT();
  if (!XtIsRealized(widget))
    XtRealizeWidget(widget);

  XTranslateCoordinates(_awt_Display,
			XtWindow(widget),
			RootWindowOfScreen(_awt_Screen),
			x, y,
			&rootx, &rooty,
			&child);

  XtVaSetValues(widget,
		XmNx, rootx,
		XmNy, rooty,
		NULL);

  if (width)
    XtVaSetValues(widget,
		  XmNwidth, width,
		  NULL);

  if (height)
    XtVaSetValues(widget,
		  XmNheight, height,
		  NULL);

  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_pDispose(JNIEnv *env,
					jobject peer)
{
  Widget window_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtDestroyWidget(window_widget);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_toBack(JNIEnv *env,
				      jobject peer)
{
  Widget window_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XLowerWindow(_awt_Display, XtWindow(window_widget));
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MWindowPeer_initIDs( JNIEnv *env,
                                        jclass cls )
{
}
