/* -*- Mode: C; c-file-style: "gnu" -*-
   toolkit.c -- native methods for sun/awt/motif/MToolkit.
   Created: Chris Toshok <toshok@hungry.com>, 3-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"
#include "common.h"

JNIEXPORT void JNICALL
Java_sun_awt_motif_MToolkit_init(JNIEnv *env,
				 jobject toolkit)
{
  PR_LOG (awtLm, PR_LOG_DEBUG, ("in Java_sun_awt_motif_MToolkit_init\n"));

  /* XXX any more to do here? */
  initialize_awt();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MToolkit_run(JNIEnv *env,
				jobject toolkit)
{
#if 0
  jclass input_thread_class;
  jclass thread_class;
  jmethodID constructor;
  jobject input_thread;

  PR_LOG (awtLm, PR_LOG_DEBUG, ("In Java_sun_awt_motif_MToolkit_run\n"));

  input_thread_class = (*env)->FindClass(env, "sun/awt/motif/InputThread");
  thread_class = (*env)->FindClass(env, "java/lang/Thread");

  constructor = (*env)->GetMethodID(env, input_thread_class, "<init>", "()V");

  input_thread = (*env)->NewObject(env, input_thread_class, constructor, NULL);
#endif
}

JNIEXPORT jobject JNICALL
Java_sun_awt_motif_MToolkit_makeColorModel(JNIEnv *env,
					   jclass cls)
{
  (*env)->FatalError(env, "Java_sun_awt_motif_MToolkit_makeColorModel not implemented.");
  return NULL;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MToolkit_getScreenResolution(JNIEnv *env,
						jobject obj)
{
  (*env)->FatalError(env, "Java_sun_awt_motif_MToolkit_getScreenResolution not implemented.");
  return 0;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MToolkit_getScreenWidth(JNIEnv *env,
					   jobject obj)
{
  jint width;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("In  Java_sun_awt_motif_MToolkit_getScreenWidth\n"));
  initialize_awt();

  LOCK_AWT();
  width = WidthOfScreen(_awt_Screen); 
  UNLOCK_AWT();

  return width;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MToolkit_getScreenHeight(JNIEnv *env,
					    jobject obj)
{
  jint height;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("In  Java_sun_awt_motif_MToolkit_getScreenHeight\n"));
  initialize_awt();

  LOCK_AWT();
  height = HeightOfScreen(_awt_Screen);
  UNLOCK_AWT();

  return height;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MToolkit_sync(JNIEnv *env,
				 jobject obj)
{
  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("In  Java_sun_awt_motif_MToolkit_sync\n"));
  LOCK_AWT();
  XSync(_awt_Display, False);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MToolkit_beep(JNIEnv *env,
				 jobject obj)
{
  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("In  Java_sun_awt_motif_MToolkit_beep\n"));
  LOCK_AWT();
  XBell(_awt_Display, 100);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MToolkit_loadSystemColors(JNIEnv *env,
					     jobject obj,
					     jintArray colors)
{
  /*  (*env)->FatalError(env, "Java_sun_awt_motif_MToolkit_loadSystemColors not implemented.");*/
}
