/* -*- Mode: C; c-file-style: "gnu" -*-
   textarea.c -- native methods for sun/awt/motif/MTextAreaPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"
#include "common.h"

#include <Xm/Xm.h>
#include <Xm/Text.h>

#include <assert.h>
#include <stdlib.h>


JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_create(JNIEnv *env,
					jobject peer,
					jobject parent_peer)
{
  Widget text;
  Widget parent;
  Widget hsb;
  Arg av[10];
  int ac;

  parent = get_component_widget(env, parent_peer);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(av[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
  XtSetArg(av[ac], XmNscrollBarPlacement, XmBOTTOM_RIGHT); ac++;
  XtSetArg(av[ac], XmNbottomOffset, 0);

  text = XmCreateScrolledText(parent,
			      "text",
			      av, ac);

  inherit_background_from(parent, XtParent(text));
  inherit_background_from(parent, text);

  XtVaGetValues(XtParent(text),
		XmNhorizontalScrollBar, &hsb,
		NULL);

  inherit_background_from(parent, hsb);
  XtSetValues(hsb, av, ac);

  UNLOCK_AWT();

  set_component_widget(env, peer, text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_pDispose(JNIEnv *env,
					  jobject peer)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextAreaPeer_getExtraWidth(JNIEnv *env,
					       jobject peer)
{
  return 0;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextAreaPeer_getExtraHeight(JNIEnv *env,
						jobject peer)
{
  return 0;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_setTextBackground(JNIEnv *env,
						   jobject peer,
						   jobject color)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_pSetEditable(JNIEnv *env,
					      jobject peer,
					      jboolean flag)
{
  Widget w = get_component_widget(env, peer);

  LOCK_AWT();
  XmTextSetEditable(w, flag);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_select(JNIEnv *env,
					jobject peer,
					jint start,
					jint end)
{
  Widget w = get_component_widget(env, peer);

  LOCK_AWT();
  XmTextSetSelection(w, start, end, CurrentTime);
  UNLOCK_AWT();
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextAreaPeer_getSelectionStart(JNIEnv *env,
						   jobject peer)
{
  Widget w = get_component_widget(env, peer);
  XmTextPosition left, right;

  LOCK_AWT();
  XmTextGetSelectionPosition(w, &left, &right);
  UNLOCK_AWT();

  return (jint)left;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextAreaPeer_getSelectionEnd(JNIEnv *env,
						 jobject peer)
{
  Widget w = get_component_widget(env, peer);
  XmTextPosition left, right;

  LOCK_AWT();
  XmTextGetSelectionPosition(w, &left, &right);
  UNLOCK_AWT();

  return (jint)right;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_setText(JNIEnv *env,
					 jobject peer,
					 jstring text)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  Widget w = get_component_widget(env, peer);
  char *text_str = HVM_StringToCString(henv, text);

  LOCK_AWT();
  XmTextSetString(w, text_str);
  UNLOCK_AWT();

  free(text_str);
}

JNIEXPORT jstring JNICALL
Java_sun_awt_motif_MTextAreaPeer_getText(JNIEnv *env,
					 jobject peer)
{
  Widget w = get_component_widget(env, peer);
  char *str;
  jstring result;

  LOCK_AWT();
  str = XmTextGetString(w);
  UNLOCK_AWT();

  result = (*env)->NewStringUTF(env, str);
  return result;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_insert(JNIEnv *env,
					jobject peer,
					jstring text,
					jint position)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  Widget w = get_component_widget(env, peer);
  char *text_str = HVM_StringToCString(henv, text);

  LOCK_AWT();
  XmTextInsert(w, position, text_str);
  UNLOCK_AWT();

  free(text_str);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_replaceRange(JNIEnv *env,
					      jobject peer,
					      jstring replacement,
					      jint range_start,
					      jint range_end)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  Widget w = get_component_widget(env, peer);
  char *replacement_text_str = HVM_StringToCString(henv, replacement);

  LOCK_AWT();
  XmTextReplace(w, range_start, range_end, replacement_text_str);
  UNLOCK_AWT();

  free(replacement_text_str);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_setFont(JNIEnv *env,
					 jobject peer,
					 jobject font)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_setCaretPosition(JNIEnv *env,
						  jobject peer,
						  jint position)
{
  Widget w = get_component_widget(env, peer);

  LOCK_AWT();
  XmTextSetInsertionPosition(w, position);
  UNLOCK_AWT();
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextAreaPeer_getCaretPosition(JNIEnv *env,
						  jobject peer)
{
  Widget w = get_component_widget(env, peer);
  XmTextPosition position;

  LOCK_AWT();
  position = XmTextGetInsertionPosition(w);
  UNLOCK_AWT();

  return (jint)position;
}

/* JDK1.1 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_setCursor(JNIEnv *env,
					   jobject peer,
					   jobject cursor)
{
  Java_sun_awt_motif_MComponentPeer_setCursor(env, peer, cursor);
}

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_pShow2(JNIEnv *env,
					jobject peer)
{
  Widget widget = get_component_widget(env, peer);

  XtManageChild(widget);
}

/* JDK1.1 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_pShow(JNIEnv *env,
				       jobject peer)
{
  Widget widget = get_component_widget(env, peer);

  XtManageChild(widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextAreaPeer_pMakeCursorVisible( JNIEnv *env,
                                                     jobject obj )
{
}
