/* -*- Mode: C; c-file-style: "gnu" -*-
   scrollpane.c -- native methods for sun/awt/motif/MScrollPanePeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "common.h"

#include "jni.h"

#include <Xm/ScrolledW.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MScrollPanePeer_create(JNIEnv *env,
					  jobject peer,
					  jobject parent_peer)
{
  Widget scroll_pane;
  Widget parent;
  Arg av[10];
  int ac;

  parent = get_component_widget(env, parent_peer);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;

  scroll_pane = XmCreateScrolledWindow(parent,
				       "scroll_pane",
				       av, ac);

  UNLOCK_AWT();

  set_component_widget(env, peer, scroll_pane);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MScrollPanePeer_pSetScrollChild(JNIEnv *env,
						   jobject peer,
						   jobject child_peer)
{
  Widget scroll_pane;
  Widget child;
  Widget hscroll = NULL, vscroll = NULL;

  scroll_pane = get_component_widget(env, peer);
  child = get_component_widget(env, child_peer);

  LOCK_AWT();
  XtVaGetValues(scroll_pane,
		XmNhorizontalScrollBar, &hscroll,
		XmNverticalScrollBar, &vscroll,
		NULL);

  XmScrolledWindowSetAreas(scroll_pane,
			   child,
			   hscroll,
			   vscroll);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MScrollPanePeer_pSetIncrement(JNIEnv *env,
						 jobject obj,
						 jint umm1,
						 jint umm2,
						 jint umm3)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MScrollPanePeer_pGetScrollbarSpace(JNIEnv *env,
						      jobject obj,
						      jint umm1)
{
  return 0;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MScrollPanePeer_pGetBlockIncrement(JNIEnv *env,
						      jobject obj,
						      jint umm1)
{
  return 0;
}

JNIEXPORT jobject JNICALL
Java_sun_awt_motif_MScrollPanePeer_pInsets(JNIEnv *env,
					   jobject obj,
					   jint umm1,
					   jint umm2,
					   jint umm3,
					   jint umm4)
{
  return NULL;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MScrollPanePeer_setScrollPosition(JNIEnv *env,
						     jobject obj,
						     jint umm1,
						     jint umm2)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MScrollPanePeer_initIDs( JNIEnv *env,
                                            jclass cls )
{
}
