/* -*- Mode: C; c-file-style: "gnu" -*-
   list.c -- native methods for sun/awt/motif/MListPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jniint.h"
#include "common.h"
#include <Xm/Xm.h>
#include <Xm/List.h>

#include <assert.h>
#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_create(JNIEnv *env,
				    jobject peer,
				    jobject parent_peer)
{
  Widget list;
  Widget parent;
  Arg av[10];
  int ac;

  PR_LOG (awtLm, PR_LOG_DEBUG, ("In Java_sun_awt_motif_MListPeer_create\n"));

  assert(NULL != peer && NULL != parent_peer);

  parent = get_component_widget(env, parent_peer);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;

  list = XmCreateScrolledList(parent,
			      "list",
			      av, ac);

  inherit_background_from(parent, list);

  UNLOCK_AWT();

  set_component_widget(env, peer, list);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_pDispose(JNIEnv *env,
				      jobject peer)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_setMultipleSelections(JNIEnv *env,
						   jobject peer,
						   jboolean flag)
{
}

JNIEXPORT jboolean JNICALL
Java_sun_awt_motif_MListPeer_isSelected(JNIEnv *env,
					jobject peer,
					jint position)
{
  Widget widget = get_component_widget(env, peer);
  jboolean is_selected;

  LOCK_AWT();
  is_selected = XmListPosSelected(widget, position);
  UNLOCK_AWT();

  return is_selected;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_addItem(JNIEnv *env,
				     jobject peer,
				     jstring item_text,
				     jint position)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  Widget widget = get_component_widget(env, peer);
  char *item_str;
  XmString item_xmstr;

  LOCK_AWT();
  item_str = HVM_StringToCString(henv, item_text);
  item_xmstr = XmStringCreateLocalized(item_str);

  XmListAddItemUnselected(widget,
			  item_xmstr,
			  position);

  XmStringFree(item_xmstr);
  UNLOCK_AWT();

  free(item_str);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_delItems(JNIEnv *env,
				      jobject peer,
				      jint start,
				      jint length)
{
  Widget widget = get_component_widget(env, peer);
  int *position_list;
  int i;

  position_list = (int*)malloc(sizeof(int) * length);
  for (i = 0; i < length; i ++)
    position_list[i] = start + i;

  LOCK_AWT();
  XmListDeletePositions(widget, position_list, length);
  UNLOCK_AWT();

  free(position_list);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_select(JNIEnv *env,
				    jobject peer,
				    jint position)
{
  Widget widget = get_component_widget(env, peer);

  LOCK_AWT();
  XmListSelectPos(widget, position, False);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_deselect(JNIEnv *env,
				      jobject peer,
				      jint position)
{
  Widget widget = get_component_widget(env, peer);

  LOCK_AWT();
  XmListDeselectPos(widget, position);
  UNLOCK_AWT();
}


JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_makeVisible(JNIEnv *env,
					 jobject peer,
					 jint position)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MListPeer_setBackground( JNIEnv *env,
                                            jobject obj,
                                            jobject a )
{
}
