/* -*- Mode: C; c-file-style: "gnu" -*-
   filedialog.c -- native methods for sun/awt/motif/MFileDialogPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"

#include "common.h"
#include <Xm/Xm.h>
#include <Xm/FileSBP.h>

#include <assert.h>
#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_create(JNIEnv *env,
					  jobject peer,
					  jobject parent_peer)
{
  Widget fs;
  Widget parent_widget;
  Widget dir_list;
  Arg av[10];
  int ac;

  printf ("creating filedialog\n");

  if (parent_peer)
    parent_widget = get_component_widget(env, parent_peer);
  else
    parent_widget = _awt_toplevelWidget;

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;

  fs = XmCreateFileSelectionDialog(parent_widget,
				   "fileSelectionDialog",
				   av, ac);

  XtVaGetValues(fs,
		XmNdirectory, &dir_list,
		NULL);

  inherit_background_from(parent_widget, fs);
  inherit_background_from(fs, XtParent(((XmFileSelectionBoxWidget)fs)->file_selection_box.dir_list));
  inherit_background_from(fs, ((XmFileSelectionBoxWidget)fs)->file_selection_box.filter_text);

  set_component_widget(env, peer, fs);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_pReshape(JNIEnv *env,
					    jobject peer,
					    jint x,
					    jint y,
					    jint width,
					    jint height)
{
  Widget fs = get_component_widget(env, peer);

  XtVaSetValues(fs,
		XmNx, x, 
		XmNy, y,
		XmNwidth, width,
		XmNheight, height,
		NULL);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_pDispose(JNIEnv *env,
					    jobject peer)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_pShow(JNIEnv *env,
					 jobject peer)
{
  Widget fs = get_component_widget(env, peer);

  printf ("showing filedialog\n");

  XtManageChild(fs);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_pHide(JNIEnv *env,
					 jobject peer)
{
  Widget fs = get_component_widget(env, peer);

  printf ("hiding filedialog\n");

  XtUnmanageChild(fs);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_setFileEntry(JNIEnv *env,
						jobject peer,
						jstring file,
						jstring directory)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_setFont(JNIEnv *env,
					   jobject peer,
					   jobject font)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_insertReplaceFileDialogText( JNIEnv *env,
                                                                jobject obj,
                                                                jstring a )
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_targetSetFile_1NoClientCode( JNIEnv *env,
                                                                jobject obj,
                                                                jobject a,
                                                                jstring b )
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFileDialogPeer_targetSetDirectory_1NoClientCode( JNIEnv *env,
                                                                     jobject obj,
                                                                     jobject a,
                                                                     jstring b )
{
}
