/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _awt_common_h
#define _awt_common_h


#include <Xm/Xm.h>

#include "jni.h"
#include "arch.h"
// #include "plevent.h"

PR_BEGIN_EXTERN_C

extern PRLogModuleInfo *awtLm;

#ifdef FOR_MOZILLA
extern PLEventQueue *_awt_eventQueue;
#endif

extern XtAppContext     _awt_appContext;
extern Widget           _awt_toplevelWidget;
extern Display*         _awt_Display;
extern Screen*          _awt_Screen;

/* in the event that there is ever someone running a threadsafe
   version of motif (probably 2.0) and threadsafe Xt and X11 libs,
   this will probably result in some meager performance
   improvement. */
#if defined( THREAD_SAFE_MOTIF )

#define LOCK_AWT()
#define UNLOCK_AWT()

#else

extern void PR_XLock(void);
extern void PR_XUnlock(void);

#define LOCK_AWT()      PR_XLock()
#define UNLOCK_AWT()    PR_XUnlock()

#endif

typedef struct GraphicsData {
    GC gc;
    Drawable drawable;
    XRectangle r;
} GraphicsData;

void initialize_awt(void);

void set_component_widget(JNIEnv *env, jobject component_peer, Widget widget);
Widget get_component_widget(JNIEnv *env, jobject component_peer);

void set_graphics_data(JNIEnv *env, jobject graphics, GraphicsData *data);
GraphicsData* get_graphics_data(JNIEnv *env, jobject graphics);

void set_menubar_widget(JNIEnv *env, jobject menubar_peer, Widget widget);
Widget get_menubar_widget(JNIEnv *env, jobject menubar_peer);
void set_menuitem_widget(JNIEnv *env, jobject menuitem_peer, Widget widget);
Widget get_menuitem_widget(JNIEnv *env, jobject menuitem_peer);
char* get_menuitem_label(JNIEnv *env, jobject component_peer);

XIM get_xim(JNIEnv *env, jobject im);
void set_xim(JNIEnv *env, jobject im, XIM xim);

char *get_checkbox_label(JNIEnv *env, jobject checkbox_peer);

void add_component_event_handler(Widget w, jobject peer);
void add_canvas_exposure_handler(Widget w, jobject peer);

void inherit_background_from(Widget parent, Widget child);

Pixel jcolor_to_pixel(JNIEnv *env, jobject color);
XFontStruct *jfont_to_xfontstruct(JNIEnv *env, jobject font);

/* cursor types */
extern jint DEFAULT_CURSOR;
extern jint CROSSHAIR_CURSOR;
extern jint TEXT_CURSOR;
extern jint WAIT_CURSOR;
extern jint SW_RESIZE_CURSOR;
extern jint SE_RESIZE_CURSOR;
extern jint NW_RESIZE_CURSOR;
extern jint NE_RESIZE_CURSOR;
extern jint N_RESIZE_CURSOR;
extern jint S_RESIZE_CURSOR;
extern jint W_RESIZE_CURSOR;
extern jint E_RESIZE_CURSOR;
extern jint HAND_CURSOR;
extern jint MOVE_CURSOR;

PR_END_EXTERN_C

#endif /* _awt_common_h */

