/* -*- Mode: C; c-file-style: "gnu" -*-
   button.c -- native methods for sun/awt/motif/MButtonPeer..
   Created: Chris Toshok <toshok@hungry.com>, 1-Apr-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "jniint.h"
#include "common.h"
#include <Xm/XmP.h>
#include <Xm/PushB.h>

#include <assert.h>
#include <stdlib.h>

static jstring
getButtonLabel(JNIEnv *env,
               Widget w)
{
  XmString label_xmstring;
  jstring str;

  XtVaGetValues(w,
                XmNlabelString, &label_xmstring,
                NULL);

  str = (*env)->NewStringUTF(env, XtName(w));

  XmStringFree(label_xmstring);

  return str;
}

static void
setButtonLabel(JNIEnv *env,
               jobject peer,
               jstring text)
{

  Widget widget = get_component_widget(env, peer);
  const jbyte *label_text = (*env)->GetStringUTFChars(env, text, NULL);
  XmString label_xmstring;

  PR_LOG (awtLm, PR_LOG_DEBUG,
          ("_setButtonLabel(%p, %s)\n", peer, label_text));

  LOCK_AWT();

  label_xmstring = XmStringCreate((const char*)label_text,
                                  XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(widget,
                XmNlabelString, label_xmstring,
                NULL);

  XmStringFree(label_xmstring);

  UNLOCK_AWT();

  (*env)->ReleaseStringUTFChars(env, text, label_text);
}

static void
buttonArmCallback(Widget w,
                  XtPointer clientData,
                  XtPointer callData)
{
}

static void
buttonDisarmCallback(Widget w,
                     XtPointer clientData,
                     XtPointer callData)
{
}

static void
buttonActivateCallback(Widget w,
                       XtPointer clientData,
                       XtPointer callData)
{
  JNIEnv *env = HVM_ThreadGetEnv()->thread_env;
  jclass peer_cls = (*env)->FindClass(env, "sun/awt/motif/MComponentPeer");
  jobject peer = (jobject)clientData;
  jfieldID target_field = (*env)->GetFieldID(env, peer_cls, "target", "Ljava/awt/Component;");
  jobject target;
  jobject event_obj;
  jmethodID ctor;
  jint id = 1001; /* XXX we should get it from the static final field ACTION_PERFORMED. */
  jclass actionEventClass = (*env)->FindClass(env, "java/awt/event/ActionEvent");
  jclass toolkit_class = (*env)->FindClass(env, "sun/awt/motif/MToolkit");
  jmethodID postEvent;
  jstring action_cmd;

  ctor = (*env)->GetMethodID(env, actionEventClass, "<init>", "(Ljava/lang/Object;ILjava/lang/String;I)V");

  target = (*env)->GetObjectField(env, peer, target_field);

  action_cmd = getButtonLabel(env, w);

  event_obj = (*env)->NewObject(env, actionEventClass,
                                ctor,
                                /* 1 */ target,
                                /* 2 */ id, /* event_id */
                                /* 3 */ action_cmd,
                                /* 4 */ 0 /* XXX modifiers */);

  postEvent = (*env)->GetStaticMethodID(env, toolkit_class,
                                        "postEvent",
                                        "(Ljava/awt/AWTEvent;)V");

  (*env)->CallStaticVoidMethod(env, toolkit_class, postEvent, event_obj);
}

void
Java_sun_awt_motif_MButtonPeer_create(JNIEnv *env,
                                      jobject peer,
                                      jobject parent_peer)
{
  Widget button;
  Widget parent;
  jclass peer_cls = (*env)->FindClass(env, "sun/awt/motif/MComponentPeer");
  jclass cls = (*env)->FindClass(env, "java/awt/Button");
  jfieldID target_field = (*env)->GetFieldID(env, peer_cls, "target", "Ljava/awt/Component;");
  jfieldID label_field = (*env)->GetFieldID(env, cls, "label", "Ljava/lang/String;");
  jobject target;
  jstring label;
  Arg av[10];
  int ac;

  PR_LOG (awtLm, PR_LOG_DEBUG,
          ("In Java_sun_awt_motif_MButtonPeer_create\n"));

  assert(NULL != peer && NULL != parent_peer);

  parent = get_component_widget(env, parent_peer);

  target = (*env)->GetObjectField(env, peer, target_field);
  label = (*env)->GetObjectField(env, target, label_field);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;

  button = XmCreatePushButton(parent,
                              "button",
                              av, ac);

  XtAddCallback(button, XmNactivateCallback, buttonActivateCallback, peer);
  XtAddCallback(button, XmNarmCallback, buttonArmCallback, peer);
  XtAddCallback(button, XmNdisarmCallback, buttonDisarmCallback, peer);

  inherit_background_from(parent, button);

  UNLOCK_AWT();

  set_component_widget(env, peer, button);

  if (label)
    setButtonLabel(env, peer, label);
}

void
Java_sun_awt_motif_MButtonPeer_setLabel(JNIEnv *env,
                                        jobject peer,
                                        jstring text)
{
  setButtonLabel(env, peer, text);
}
