/* -*- Mode: C; c-file-style: "gnu" -*-
   accesscontroller.c -- native methods for java/security/AccessController.
   Created: Chris Toshok <toshok@hungry.com>, 10-Nov-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"
#include "compat.h"
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#define MYLOG "Native"

JNIEXPORT jobject JNICALL
Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedAction_2(JNIEnv *env,
										    jclass cls,
										    jobject priv_action)
{
  jclass action_class = (*env)->GetObjectClass(env, priv_action);
  jmethodID run_method = (*env)->GetMethodID(env, action_class, "run", "()Ljava/lang/Object;");

  return (*env)->CallObjectMethod(env, priv_action, run_method);
}

JNIEXPORT jobject JNICALL
Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedAction_2Ljava_security_AccessControlContext_2(JNIEnv *env,
															 jclass cls,
															 jobject priv_action,
															 jobject context)
{
  return (*env)->NewStringUTF(env, "");
}

JNIEXPORT jobject JNICALL
Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedExceptionAction_2(JNIEnv *env,
											     jclass cls,
											     jobject priv_excep_action)
{
  jclass action_class = (*env)->GetObjectClass(env, priv_excep_action);
  jmethodID run_method = (*env)->GetMethodID(env, action_class, "run", "()Ljava/lang/Object;");

  return (*env)->CallObjectMethod(env, priv_excep_action, run_method);
}

JNIEXPORT jobject JNICALL
Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedExceptionAction_2Ljava_security_AccessControlContext_2(JNIEnv *env,
																  jclass cls,
																  jobject priv_excep_action,
																  jobject context)
{
  return (*env)->NewStringUTF(env, "");
}

JNIEXPORT jobject JNICALL
Java_java_security_AccessController_getInheritedAccessControlContext(JNIEnv *env,
								     jclass cls)
{
  return (*env)->NewStringUTF(env, "");
}



JNIEXPORT jobject JNICALL
Java_java_security_AccessController_getStackAccessControlContext(JNIEnv *env,
								 jclass cls)
{
  return NULL;
}
