/* -*- Mode: C; c-file-style: "gnu" -*-
   secmgr.c -- native methods for java/lang/SecurityManager.
   Created: Chris Toshok <toshok@hungry.com>, 28-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"

#include <stdlib.h>
#include <string.h>

JNIEXPORT jobjectArray JNICALL
Java_java_lang_SecurityManager_getClassContext(JNIEnv *env,
					       jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  StackFrame *f;
  int num_frames = 0;
  int i;
  jarray cls_array;
  jclass cls_cls = (*env)->FindClass(env, "java/lang/Class");
  
  f = henv->top_frame;
  while (f != henv->stack_highwater)
    {
      num_frames ++;
      
      f = f->parent;
    }
  
  cls_array = (*env)->NewObjectArray(env, num_frames, cls_cls, NULL);
  
  i = 0;
  f = henv->top_frame;
  while (f != henv->stack_highwater)
    {
      if (!(f->flags & FRAME_NATIVE))
	(*env)->SetObjectArrayElement(env, cls_array,
				      i++,
				      clazzfile_to_jclass(henv, f->method->clazz));
      f = f->parent;
    }
  
  return cls_array;
}

/* JDK1.1 */
JNIEXPORT jobject JNICALL
Java_java_lang_SecurityManager_currentClassLoader(JNIEnv *env,
						  jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  StackFrame *f;

  f = henv->top_frame;
  while (f != henv->stack_highwater)
    {
      if (f->method->clazz->classloader != NULL)
	return f->method->clazz->classloader;

      f = f->parent;
    }
  
  return NULL;
}
/* JDK1.2 */
JNIEXPORT jobject JNICALL
Java_java_lang_SecurityManager_currentClassLoader0(JNIEnv *env,
						   jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  StackFrame *f;

  f = henv->top_frame;
  while (f != henv->stack_highwater)
    {
      if (f->method->clazz->classloader != NULL)
	return f->method->clazz->classloader;

      f = f->parent;
    }
  
  return NULL;
}

JNIEXPORT jint JNICALL
Java_java_lang_SecurityManager_classDepth(JNIEnv *env,
					  jobject obj,
					  jstring name)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  StackFrame *f;
  char *cls_name;
  int cls_name_length;
  const jbyte *cls_name_bytes;
  int depth = -1;
  int top_depth;

  cls_name_bytes = (*env)->GetStringUTFChars(env, name, NULL);

  cls_name_length = (*env)->GetStringUTFLength(env, name) + 1;
  cls_name = (char*)malloc(cls_name_length * sizeof(char));

  strncpy(cls_name, (char*)cls_name_bytes, cls_name_length);

  (*env)->ReleaseStringUTFChars(env, name, cls_name_bytes);

  f = henv->top_frame;
  top_depth = f->depth;
  while (f != henv->stack_highwater)
    {
      if (!strcmp(cls_name, getClassName(env, f->method->clazz)))
	{
	  depth = top_depth - f->depth;
	  break;
	}

      f = f->parent;
    }
  
  return depth;
}

/* JDK1.1 */
JNIEXPORT jint JNICALL
Java_java_lang_SecurityManager_classLoaderDepth(JNIEnv *env,
						jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  StackFrame *f;
  int depth = -1;
  int top_depth;

  f = henv->top_frame;
  top_depth = f->depth;
  while (f != henv->stack_highwater)
    {
      if (f->method->clazz->classloader != NULL)
	{
	  depth = top_depth - f->depth;
	  break;
	}

      f = f->parent;
    }
  
  return depth;
}
/* JDK1.2 */
JNIEXPORT jint JNICALL
Java_java_lang_SecurityManager_classLoaderDepth0(JNIEnv *env,
						 jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  StackFrame *f;
  int depth = -1;
  int top_depth;

  f = henv->top_frame;
  top_depth = f->depth;
  while (f != henv->stack_highwater)
    {
      if (f->method->clazz->classloader != NULL)
	{
	  depth = top_depth - f->depth;
	  break;
	}

      f = f->parent;
    }
  
  return depth;
}

JNIEXPORT jobject JNICALL
Java_java_lang_SecurityManager_currentLoadedClass0(JNIEnv *env,
						   jobject obj)
{
  /* not really sure what this one is supposed to do... */
  (*env)->FatalError(env, "java.lang.SecurityManager.currentLoadedClass0() unimplemented");
  return NULL;
}
