/* -*- Mode: C; c-file-style: "gnu" -*-
   jvmdimm.c -- JVMDI Memory Management Functions
   Created: Hernan Otero <hernan_otero@bigfoot.com>, 18-Jul-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jvmdiint.h"

static JVMDI_AllocHook alloc_hook = NULL;
static JVMDI_DeallocHook dealloc_hook = NULL;

JNIEXPORT jvmdiError JNICALL
JVMDI_SetAllocationHooks(JNIEnv *env, 
			 JVMDI_AllocHook ahook,
			 JVMDI_DeallocHook dhook)
{
  PR_ASSERT(env != NULL);
  alloc_hook = ahook;
  dealloc_hook = dhook;
  return JVMDI_ERROR_NONE;
}

JNIEXPORT jvmdiError JNICALL
JVMDI_Allocate(JNIEnv *env, 
	       jlong size,
	       jbyte** memPtr)
{
  if (alloc_hook != NULL) {
    return alloc_hook(env, size, memPtr);
  }
  if (env == NULL || memPtr == NULL) {
    return JVMDI_ERROR_NULL_POINTER;
  }
  *memPtr = PR_MALLOC((PRUint32)size);
  if (*memPtr == NULL) {
    return JVMDI_ERROR_OUT_OF_MEMORY;
  }
  return JVMDI_ERROR_NONE;
}

JNIEXPORT jvmdiError JNICALL
JVMDI_Deallocate(JNIEnv *env, 
		 jbyte* mem)
{
  if (dealloc_hook != NULL) {
    return dealloc_hook(env, mem);
  }
  if (env == NULL || mem == NULL) {
    return JVMDI_ERROR_NULL_POINTER;
  }
  PR_DELETE(mem);
  return JVMDI_ERROR_NONE;
}
