/* -*- Mode: C; c-file-style: "gnu" -*-
   jvmdifld.c -- JVMDI Field Information Functions
   Created: Hernan Otero <hernan_otero@bigfoot.com>, 18-Jul-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jvmdiint.h"

JNIEXPORT jvmdiError JNICALL
JVMDI_GetFieldName(JNIEnv *env, jclass clazz, jfieldID field, 
                   char **namePtr, char **signaturePtr)
{
  /* the usual NULL check. */
  if (env == NULL
      || namePtr == NULL
      || signaturePtr == NULL)
    return JVMDI_ERROR_NULL_POINTER;

  if (clazz == NULL)
    return JVMDI_ERROR_INVALID_CLASS;

  if (field == NULL)
    return JVMDI_ERROR_INVALID_FIELDID;

  *namePtr = field->name;
  *signaturePtr = field->sig_str;
  return JVMDI_ERROR_NONE;
}

JNIEXPORT jvmdiError JNICALL
JVMDI_GetFieldDeclaringClass(JNIEnv *env, jclass clazz, jfieldID field,
 			     jclass *declaringClassPtr)
{
  HungryEnv *henv = HVM_ThreadGetEnv();

  /* the usual NULL check. */
  if (env == NULL
      || declaringClassPtr == NULL)
    return JVMDI_ERROR_NULL_POINTER;

  if (clazz == NULL)
    return JVMDI_ERROR_INVALID_CLASS;

  if (field == NULL)
    return JVMDI_ERROR_INVALID_FIELDID;

  *declaringClassPtr = clazzfile_to_jclass(henv, field->clazz);
  return JVMDI_ERROR_NONE;
}

JNIEXPORT jvmdiError JNICALL
JVMDI_GetFieldModifiers(JNIEnv *env, jclass clazz, jfieldID field,
                        jint *modifiersPtr)
{
  /* the usual NULL check. */
  if (env == NULL
      || modifiersPtr == NULL)
    return JVMDI_ERROR_NULL_POINTER;

  if (clazz == NULL)
    return JVMDI_ERROR_INVALID_CLASS;

  if (field == NULL)
    return JVMDI_ERROR_INVALID_FIELDID;

  *modifiersPtr = field->access_flags;
  return JVMDI_ERROR_NONE;
}
