/* -*- Mode: C; c-file-style: "gnu"; indent-tabs-mode:nil -*-
   jniref.c -- Java Native Interface methods relating to local or global references.
   Created: Chris Toshok <toshok@hungry.com>, 26-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jni.h"
#include "jniint.h"
#include "qop.h"

jobject
JNIFUNC(NewGlobalRef)(JNIEnv *env,
                      jobject obj)
{
  return obj; /* XXX */
}

void
JNIFUNC(DeleteGlobalRef)(JNIEnv *env,
                         jobject globalRef)
{
  /* XXX */
}

void
JNIFUNC(DeleteLocalRef)(JNIEnv *env,
                        jobject localRef)
{
}

/* new for JDK 1.2 */

jint
JNIFUNC(EnsureLocalCapacity)(JNIEnv *env, jint capacity)
{
  (*env)->FatalError(env, "JNI EnsureLocalCapacity not implemented yet.\n");
  return 0;
}

jint
JNIFUNC(PushLocalFrame)(JNIEnv *env, jint capacity)
{
  (*env)->FatalError(env, "JNI PushLocalFrame not implemented yet.\n");
  return 0;
}

jobject
JNIFUNC(PopLocalFrame)(JNIEnv *env, jobject result)
{
  (*env)->FatalError(env, "JNI PopLocalFrame not implemented yet.\n");
  return 0;
}

jobject
JNIFUNC(NewLocalRef)(JNIEnv *env, jobject ref)
{
  (*env)->FatalError(env, "JNI NewLocalRef not implemented yet.\n");
  return 0;
}


jweak
JNIFUNC(NewWeakGlobalRef)(JNIEnv *env, jobject obj)
{
  (*env)->FatalError(env, "JNI NewWeakGlobalRef not implemented yet.\n");
  return 0;
}

void
JNIFUNC(DeleteWeakGlobalRef)(JNIEnv *env, jweak obj)
{
  (*env)->FatalError(env, "JNI DeleteWeakGlobalRef not implemented yet.\n");
}
