/* -*- Mode: C; c-file-style: "gnu"; indent-tabs-mode:nil -*-
   jniint.h -- Java Native Interface internal header file.
   Created: Chris Toshok <toshok@hungry.com>, 26-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _hungry_jniint_h
#define _hungry_jniint_h

#include "nspr.h"

PR_BEGIN_EXTERN_C

#include "jni.h"
#include "runtimeint.h"

#define JNIFUNC(x) _hungryJNI_##x

#define JavaVMToHVM(vm) ((HungryVM*)(*(vm))->_sun1)
#define JNIEnvToHEnv(env) ((HungryEnv*)(*(env))->_sun0)

/* verify modes -- since sun in their infinite wisdom used plain integers
     and didn't spec a more intuitive enumerated set of constants. */
enum {
  VERIFY_NONE,
  VERIFY_REMOTE, /* verify only code loaded from a remote source */
  VERIFY_ALL
};

PR_EXTERN(jclass) sig_to_jclass(HungryEnv *env, char *sig_str);

JNIEnv* JNIFUNC(AllocJNIEnv)(void);
void JNIFUNC(DeallocJNIEnv)(JNIEnv*);
JavaVM* JNIFUNC(AllocJavaVM)(void);
void JNIFUNC(DeallocJavaVM)(JavaVM*);

jint JNIFUNC(GetVersion)(JNIEnv *env);

jclass JNIFUNC(DefineClass)(JNIEnv *env, jobject loader, const jbyte* buf, jsize bufLen);
jclass JNIFUNC(FindClass)(JNIEnv *env, const char *name);
jclass JNIFUNC(GetSuperclass)(JNIEnv *env, jclass clazz);
jboolean JNIFUNC(IsAssignableFrom)(JNIEnv *env, jclass clazz1, jclass clazz2);

jint JNIFUNC(Throw)(JNIEnv *env, jthrowable obj);
jint JNIFUNC(ThrowNew)(JNIEnv *env, jclass clazz, const char *message);
jthrowable JNIFUNC(ExceptionOccurred)(JNIEnv *env);
void JNIFUNC(ExceptionDescribe)(JNIEnv *env);
void JNIFUNC(ExceptionClear)(JNIEnv *env);
void JNIFUNC(FatalError)(JNIEnv *env, const char *msg);

jobject JNIFUNC(NewGlobalRef)(JNIEnv *env, jobject obj);
void JNIFUNC(DeleteGlobalRef)(JNIEnv *env, jobject globalRef);
void JNIFUNC(DeleteLocalRef)(JNIEnv *env, jobject localRef);

jobject JNIFUNC(AllocObject)(JNIEnv *env, jclass clazz);
jobject JNIFUNC(NewObject)(JNIEnv *env, jclass clazz,
                           jmethodID methodID, ...);
jobject JNIFUNC(NewObjectA)(JNIEnv *env, jclass clazz,
                            jmethodID methodID, jvalue *args);
jobject JNIFUNC(NewObjectV)(JNIEnv *env, jclass clazz,
                            jmethodID methodID, va_list args);
jclass JNIFUNC(GetObjectClass)(JNIEnv *env, jobject obj);
jboolean JNIFUNC(IsInstanceOf)(JNIEnv *env, jobject obj, jclass clazz);
jboolean JNIFUNC(IsSameObject)(JNIEnv *env, jobject ref, jobject ref2);

jfieldID JNIFUNC(GetFieldID)(JNIEnv *env, jclass clazz,
                             const char *name, const char *sig);
jboolean JNIFUNC(GetBooleanField)(JNIEnv *env, jobject obj,
                                  jfieldID fieldID);
jbyte JNIFUNC(GetByteField)(JNIEnv *env, jobject obj,
                            jfieldID fieldID);
jchar JNIFUNC(GetCharField)(JNIEnv *env, jobject obj,
                            jfieldID fieldID);
jshort JNIFUNC(GetShortField)(JNIEnv *env, jobject obj,
                              jfieldID fieldID);
jint JNIFUNC(GetIntField)(JNIEnv *env, jobject obj,
                          jfieldID fieldID);
jlong JNIFUNC(GetLongField)(JNIEnv *env, jobject obj,
                            jfieldID fieldID);
jfloat JNIFUNC(GetFloatField)(JNIEnv *env, jobject obj,
                              jfieldID fieldID);
jdouble JNIFUNC(GetDoubleField)(JNIEnv *env, jobject obj,
                                jfieldID fieldID);
jobject JNIFUNC(GetObjectField)(JNIEnv *env, jobject obj,
                                jfieldID fieldID);

void JNIFUNC(SetBooleanField)(JNIEnv *env, jobject obj,
                              jfieldID fieldID, jboolean value);
void JNIFUNC(SetByteField)(JNIEnv *env, jobject obj,
                           jfieldID fieldID, jbyte value);
void JNIFUNC(SetCharField)(JNIEnv *env, jobject obj,
                           jfieldID fieldID, jchar value);
void JNIFUNC(SetShortField)(JNIEnv *env, jobject obj,
                            jfieldID fieldID, jshort value);
void JNIFUNC(SetIntField)(JNIEnv *env, jobject obj,
                          jfieldID fieldID, jint value);
void JNIFUNC(SetLongField)(JNIEnv *env, jobject obj,
                           jfieldID fieldID, jlong value);
void JNIFUNC(SetFloatField)(JNIEnv *env, jobject obj,
                            jfieldID fieldID, jfloat value);
void JNIFUNC(SetDoubleField)(JNIEnv *env, jobject obj,
                             jfieldID fieldID, jdouble value);
void JNIFUNC(SetObjectField)(JNIEnv *env, jobject obj,
                             jfieldID fieldID, jobject value);

jmethodID JNIFUNC(GetMethodID)(JNIEnv *env, jclass clazz,
                               const char *name, const char *sig);
jboolean JNIFUNC(CallBooleanMethod)(JNIEnv *env, jobject obj,
                                    jmethodID methodID, ...);
jboolean JNIFUNC(CallBooleanMethodA)(JNIEnv *env, jobject obj,
                                     jmethodID methodID, jvalue *args);
jboolean JNIFUNC(CallBooleanMethodV)(JNIEnv *env, jobject obj,
                                     jmethodID methodID, va_list args);
jbyte JNIFUNC(CallByteMethod)(JNIEnv *env, jobject obj,
                              jmethodID methodID, ...);
jbyte JNIFUNC(CallByteMethodA)(JNIEnv *env, jobject obj,
                               jmethodID methodID, jvalue *args);
jbyte JNIFUNC(CallByteMethodV)(JNIEnv *env, jobject obj,
                               jmethodID methodID, va_list args);
jchar JNIFUNC(CallCharMethod)(JNIEnv *env, jobject obj,
                              jmethodID methodID, ...);
jchar JNIFUNC(CallCharMethodA)(JNIEnv *env, jobject obj,
                               jmethodID methodID, jvalue *args);
jchar JNIFUNC(CallCharMethodV)(JNIEnv *env, jobject obj,
                               jmethodID methodID, va_list args);
jshort JNIFUNC(CallShortMethod)(JNIEnv *env, jobject obj,
                                jmethodID methodID, ...);
jshort JNIFUNC(CallShortMethodA)(JNIEnv *env, jobject obj,
                                 jmethodID methodID, jvalue *args);
jshort JNIFUNC(CallShortMethodV)(JNIEnv *env, jobject obj,
                                 jmethodID methodID, va_list args);
jint JNIFUNC(CallIntMethod)(JNIEnv *env, jobject obj,
                            jmethodID methodID, ...);
jint JNIFUNC(CallIntMethodA)(JNIEnv *env, jobject obj,
                             jmethodID methodID, jvalue *args);
jint JNIFUNC(CallIntMethodV)(JNIEnv *env, jobject obj,
                             jmethodID methodID, va_list args);
jlong JNIFUNC(CallLongMethod)(JNIEnv *env, jobject obj,
                              jmethodID methodID, ...);
jlong JNIFUNC(CallLongMethodA)(JNIEnv *env, jobject obj,
                               jmethodID methodID, jvalue *args);
jlong JNIFUNC(CallLongMethodV)(JNIEnv *env, jobject obj,
                               jmethodID methodID, va_list args);
jfloat JNIFUNC(CallFloatMethod)(JNIEnv *env, jobject obj,
                                jmethodID methodID, ...);
jfloat JNIFUNC(CallFloatMethodA)(JNIEnv *env, jobject obj,
                                 jmethodID methodID, jvalue *args);
jfloat JNIFUNC(CallFloatMethodV)(JNIEnv *env, jobject obj,
                                 jmethodID methodID, va_list args);
jdouble JNIFUNC(CallDoubleMethod)(JNIEnv *env, jobject obj,
                                  jmethodID methodID, ...);
jdouble JNIFUNC(CallDoubleMethodA)(JNIEnv *env, jobject obj,
                                   jmethodID methodID, jvalue *args);
jdouble JNIFUNC(CallDoubleMethodV)(JNIEnv *env, jobject obj,
                                   jmethodID methodID, va_list args);
void JNIFUNC(CallVoidMethod)(JNIEnv *env, jobject obj,
                             jmethodID methodID, ...);
void JNIFUNC(CallVoidMethodA)(JNIEnv *env, jobject obj,
                              jmethodID methodID, jvalue *args);
void JNIFUNC(CallVoidMethodV)(JNIEnv *env, jobject obj,
                              jmethodID methodID, va_list args);
jobject JNIFUNC(CallObjectMethod)(JNIEnv *env, jobject obj,
                                  jmethodID methodID, ...);
jobject JNIFUNC(CallObjectMethodA)(JNIEnv *env, jobject obj,
                                   jmethodID methodID, jvalue *args);
jobject JNIFUNC(CallObjectMethodV)(JNIEnv *env, jobject obj,
                                   jmethodID methodID, va_list args);

jboolean JNIFUNC(CallNonvirtualBooleanMethod)(JNIEnv *env, jobject obj,
                                              jmethodID methodID, ...);
jboolean JNIFUNC(CallNonvirtualBooleanMethodA)(JNIEnv *env, jobject obj,
                                               jmethodID methodID, jvalue *args);
jboolean JNIFUNC(CallNonvirtualBooleanMethodV)(JNIEnv *env, jobject obj,
                                               jmethodID methodID, va_list args);
jbyte JNIFUNC(CallNonvirtualByteMethod)(JNIEnv *env, jobject obj,
                                        jmethodID methodID, ...);
jbyte JNIFUNC(CallNonvirtualByteMethodA)(JNIEnv *env, jobject obj,
                                         jmethodID methodID, jvalue *args);
jbyte JNIFUNC(CallNonvirtualByteMethodV)(JNIEnv *env, jobject obj,
                                         jmethodID methodID, va_list args);
jchar JNIFUNC(CallNonvirtualCharMethod)(JNIEnv *env, jobject obj,
                                        jmethodID methodID, ...);
jchar JNIFUNC(CallNonvirtualCharMethodA)(JNIEnv *env, jobject obj,
                                         jmethodID methodID, jvalue *args);
jchar JNIFUNC(CallNonvirtualCharMethodV)(JNIEnv *env, jobject obj,
                                         jmethodID methodID, va_list args);
jshort JNIFUNC(CallNonvirtualShortMethod)(JNIEnv *env, jobject obj,
                                          jmethodID methodID, ...);
jshort JNIFUNC(CallNonvirtualShortMethodA)(JNIEnv *env, jobject obj,
                                           jmethodID methodID, jvalue *args);
jshort JNIFUNC(CallNonvirtualShortMethodV)(JNIEnv *env, jobject obj,
                                           jmethodID methodID, va_list args);
jint JNIFUNC(CallNonvirtualIntMethod)(JNIEnv *env, jobject obj,
                                      jmethodID methodID, ...);
jint JNIFUNC(CallNonvirtualIntMethodA)(JNIEnv *env, jobject obj,
                                       jmethodID methodID, jvalue *args);
jint JNIFUNC(CallNonvirtualIntMethodV)(JNIEnv *env, jobject obj,
                                       jmethodID methodID, va_list args);
jlong JNIFUNC(CallNonvirtualLongMethod)(JNIEnv *env, jobject obj,
                                        jmethodID methodID, ...);
jlong JNIFUNC(CallNonvirtualLongMethodA)(JNIEnv *env, jobject obj,
                                         jmethodID methodID, jvalue *args);
jlong JNIFUNC(CallNonvirtualLongMethodV)(JNIEnv *env, jobject obj,
                                         jmethodID methodID, va_list args);
jfloat JNIFUNC(CallNonvirtualFloatMethod)(JNIEnv *env, jobject obj,
                                          jmethodID methodID, ...);
jfloat JNIFUNC(CallNonvirtualFloatMethodA)(JNIEnv *env, jobject obj,
                                           jmethodID methodID, jvalue *args);
jfloat JNIFUNC(CallNonvirtualFloatMethodV)(JNIEnv *env, jobject obj,
                                           jmethodID methodID, va_list args);
jdouble JNIFUNC(CallNonvirtualDoubleMethod)(JNIEnv *env, jobject obj,
                                            jmethodID methodID, ...);
jdouble JNIFUNC(CallNonvirtualDoubleMethodA)(JNIEnv *env, jobject obj,
                                             jmethodID methodID, jvalue *args);
jdouble JNIFUNC(CallNonvirtualDoubleMethodV)(JNIEnv *env, jobject obj,
                                             jmethodID methodID, va_list args);
void JNIFUNC(CallNonvirtualVoidMethod)(JNIEnv *env, jobject obj,
                                       jmethodID methodID, ...);
void JNIFUNC(CallNonvirtualVoidMethodA)(JNIEnv *env, jobject obj,
                                        jmethodID methodID, jvalue *args);
void JNIFUNC(CallNonvirtualVoidMethodV)(JNIEnv *env, jobject obj,
                                        jmethodID methodID, va_list args);
jobject JNIFUNC(CallNonvirtualObjectMethod)(JNIEnv *env, jobject obj,
                                            jmethodID methodID, ...);
jobject JNIFUNC(CallNonvirtualObjectMethodA)(JNIEnv *env, jobject obj,
                                             jmethodID methodID, jvalue *args);
jobject JNIFUNC(CallNonvirtualObjectMethodV)(JNIEnv *env, jobject obj,
                                             jmethodID methodID, va_list args);

jmethodID JNIFUNC(GetStaticMethodID)(JNIEnv *env, jclass clazz,
                                     const char *name, const char *sig);
jboolean JNIFUNC(CallStaticBooleanMethod)(JNIEnv *env, jclass clazz,
                                          jmethodID methodID, ...);
jboolean JNIFUNC(CallStaticBooleanMethodA)(JNIEnv *env, jclass clazz,
                                           jmethodID methodID, jvalue *args);
jboolean JNIFUNC(CallStaticBooleanMethodV)(JNIEnv *env, jclass clazz,
                                           jmethodID methodID, va_list args);
jbyte JNIFUNC(CallStaticByteMethod)(JNIEnv *env, jclass clazz,
                                    jmethodID methodID, ...);
jbyte JNIFUNC(CallStaticByteMethodA)(JNIEnv *env, jclass clazz,
                                     jmethodID methodID, jvalue *args);
jbyte JNIFUNC(CallStaticByteMethodV)(JNIEnv *env, jclass clazz,
                                     jmethodID methodID, va_list args);
jchar JNIFUNC(CallStaticCharMethod)(JNIEnv *env, jclass clazz,
                                    jmethodID methodID, ...);
jchar JNIFUNC(CallStaticCharMethodA)(JNIEnv *env, jclass clazz,
                                     jmethodID methodID, jvalue *args);
jchar JNIFUNC(CallStaticCharMethodV)(JNIEnv *env, jclass clazz,
                                     jmethodID methodID, va_list args);
jshort JNIFUNC(CallStaticShortMethod)(JNIEnv *env, jclass clazz,
                                      jmethodID methodID, ...);
jshort JNIFUNC(CallStaticShortMethodA)(JNIEnv *env, jclass clazz,
                                       jmethodID methodID, jvalue *args);
jshort JNIFUNC(CallStaticShortMethodV)(JNIEnv *env, jclass clazz,
                                       jmethodID methodID, va_list args);
jint JNIFUNC(CallStaticIntMethod)(JNIEnv *env, jclass clazz,
                                  jmethodID methodID, ...);
jint JNIFUNC(CallStaticIntMethodA)(JNIEnv *env, jclass clazz,
                                   jmethodID methodID, jvalue *args);
jint JNIFUNC(CallStaticIntMethodV)(JNIEnv *env, jclass clazz,
                                   jmethodID methodID, va_list args);
jlong JNIFUNC(CallStaticLongMethod)(JNIEnv *env, jclass clazz,
                                    jmethodID methodID, ...);
jlong JNIFUNC(CallStaticLongMethodA)(JNIEnv *env, jclass clazz,
                                     jmethodID methodID, jvalue *args);
jlong JNIFUNC(CallStaticLongMethodV)(JNIEnv *env, jclass clazz,
                                     jmethodID methodID, va_list args);
jfloat JNIFUNC(CallStaticFloatMethod)(JNIEnv *env, jclass clazz,
                                      jmethodID methodID, ...);
jfloat JNIFUNC(CallStaticFloatMethodA)(JNIEnv *env, jclass clazz,
                                       jmethodID methodID, jvalue *args);
jfloat JNIFUNC(CallStaticFloatMethodV)(JNIEnv *env, jclass clazz,
                                       jmethodID methodID, va_list args);
jdouble JNIFUNC(CallStaticDoubleMethod)(JNIEnv *env, jclass clazz,
                                        jmethodID methodID, ...);
jdouble JNIFUNC(CallStaticDoubleMethodA)(JNIEnv *env, jclass clazz,
                                         jmethodID methodID, jvalue *args);
jdouble JNIFUNC(CallStaticDoubleMethodV)(JNIEnv *env, jclass clazz,
                                         jmethodID methodID, va_list args);
void JNIFUNC(CallStaticVoidMethod)(JNIEnv *env, jclass clazz,
                                   jmethodID methodID, ...);
void JNIFUNC(CallStaticVoidMethodA)(JNIEnv *env, jclass clazz,
                                    jmethodID methodID, jvalue *args);
void JNIFUNC(CallStaticVoidMethodV)(JNIEnv *env, jclass clazz,
                                    jmethodID methodID, va_list args);
jobject JNIFUNC(CallStaticObjectMethod)(JNIEnv *env, jclass clazz,
                                        jmethodID methodID, ...);
jobject JNIFUNC(CallStaticObjectMethodA)(JNIEnv *env, jclass clazz,
                                         jmethodID methodID, jvalue *args);
jobject JNIFUNC(CallStaticObjectMethodV)(JNIEnv *env, jclass clazz,
                                         jmethodID methodID, va_list args);


jfieldID JNIFUNC(GetStaticFieldID)(JNIEnv *env, jclass clazz,
                                   const char *name, const char *sig);
jboolean JNIFUNC(GetStaticBooleanField)(JNIEnv *env, jclass clazz,
                                        jfieldID fieldID);
jbyte JNIFUNC(GetStaticByteField)(JNIEnv *env, jclass clazz,
                                  jfieldID fieldID);
jchar JNIFUNC(GetStaticCharField)(JNIEnv *env, jclass clazz,
                                  jfieldID fieldID);
jshort JNIFUNC(GetStaticShortField)(JNIEnv *env, jclass clazz,
                                    jfieldID fieldID);
jint JNIFUNC(GetStaticIntField)(JNIEnv *env, jclass clazz,
                                jfieldID fieldID);
jlong JNIFUNC(GetStaticLongField)(JNIEnv *env, jclass clazz,
                                  jfieldID fieldID);
jfloat JNIFUNC(GetStaticFloatField)(JNIEnv *env, jclass clazz,
                                    jfieldID fieldID);
jdouble JNIFUNC(GetStaticDoubleField)(JNIEnv *env, jclass clazz,
                                      jfieldID fieldID);
jobject JNIFUNC(GetStaticObjectField)(JNIEnv *env, jclass clazz,
                                      jfieldID fieldID);

void JNIFUNC(SetStaticBooleanField)(JNIEnv *env, jclass clazz,
                                    jfieldID fieldID, jboolean value);
void JNIFUNC(SetStaticByteField)(JNIEnv *env, jclass clazz,
                                 jfieldID fieldID, jbyte value);
void JNIFUNC(SetStaticCharField)(JNIEnv *env, jclass clazz,
                                 jfieldID fieldID, jchar value);
void JNIFUNC(SetStaticShortField)(JNIEnv *env, jclass clazz,
                                  jfieldID fieldID, jshort value);
void JNIFUNC(SetStaticIntField)(JNIEnv *env, jclass clazz,
                                jfieldID fieldID, jint value);
void JNIFUNC(SetStaticLongField)(JNIEnv *env, jclass clazz,
                                 jfieldID fieldID, jlong value);
void JNIFUNC(SetStaticFloatField)(JNIEnv *env, jclass clazz,
                                  jfieldID fieldID, jfloat value);
void JNIFUNC(SetStaticDoubleField)(JNIEnv *env, jclass clazz,
                                   jfieldID fieldID, jdouble value);
void JNIFUNC(SetStaticObjectField)(JNIEnv *env, jclass clazz,
                                   jfieldID fieldID, jobject value);

jstring JNIFUNC(NewString)(JNIEnv *env, const jchar *unicodeChars, jsize len);
jsize JNIFUNC(GetStringLength)(JNIEnv *env, jstring string);
jchar* JNIFUNC(GetStringChars)(JNIEnv *env, jstring string, jboolean *isCopy);
void JNIFUNC(ReleaseStringChars)(JNIEnv *env, jstring string, const jchar *chars);
jstring JNIFUNC(NewStringUTF)(JNIEnv *env, const char *bytes);
jsize JNIFUNC(GetStringUTFLength)(JNIEnv *env, jstring string);
const char* JNIFUNC(GetStringUTFChars)(JNIEnv *env, jstring string, jboolean *isCopy);
void JNIFUNC(ReleaseStringUTFChars)(JNIEnv *env, jstring string, const char *utf);
void JNIFUNC(GetStringRegion)(JNIEnv* env, jstring string, jsize start,
                              jsize len, jchar * buf );
void JNIFUNC(GetStringUTFRegion)(JNIEnv *env, jstring string,
                                 jsize start, jsize len, char * buf );
const jchar *JNIFUNC(GetStringCritical)(JNIEnv *env, jstring string, 
                                        jboolean *isCopy);
void JNIFUNC(ReleaseStringCritical)(JNIEnv *env, jstring string,
                                    const jchar *carray);

jsize JNIFUNC(GetArrayLength)(JNIEnv *env, jarray array);
jarray JNIFUNC(NewObjectArray)(JNIEnv *env, jsize length,
                               jclass elementClass, jobject initialElement);
jobject JNIFUNC(GetObjectArrayElement)(JNIEnv *env, jobjectArray array, jsize index);
void JNIFUNC(SetObjectArrayElement)(JNIEnv *env, jobjectArray array,
                                    jsize index, jobject value);

jbooleanArray JNIFUNC(NewBooleanArray)(JNIEnv *env, jsize length);
jboolean* JNIFUNC(GetBooleanArrayElements)(JNIEnv *env, jbooleanArray array,
                                           jboolean* isCopy);
void JNIFUNC(ReleaseBooleanArrayElements)(JNIEnv *env, jbooleanArray array,
                                          jboolean* elems, jint mode);
void JNIFUNC(GetBooleanArrayRegion)(JNIEnv *env, jbooleanArray array,
                                    jsize start, jsize len, jboolean* buf);
void JNIFUNC(SetBooleanArrayRegion)(JNIEnv *env, jbooleanArray array,
                                    jsize start, jsize len, jboolean* buf);
jbyteArray JNIFUNC(NewByteArray)(JNIEnv *env, jsize length);
jbyte* JNIFUNC(GetByteArrayElements)(JNIEnv *env, jbyteArray array,
                                     jboolean* isCopy);
void JNIFUNC(ReleaseByteArrayElements)(JNIEnv *env, jbyteArray array,
                                       jbyte* elems, jint mode);
void JNIFUNC(GetByteArrayRegion)(JNIEnv *env, jbyteArray array,
                                 jsize start, jsize len, jbyte* buf);
void JNIFUNC(SetByteArrayRegion)(JNIEnv *env, jbyteArray array,
                                 jsize start, jsize len, jbyte* buf);
jcharArray JNIFUNC(NewCharArray)(JNIEnv *env, jsize length);
jchar* JNIFUNC(GetCharArrayElements)(JNIEnv *env, jcharArray array,
                                     jboolean* isCopy);
void JNIFUNC(ReleaseCharArrayElements)(JNIEnv *env, jcharArray array,
                                       jchar* elems, jint mode);
void JNIFUNC(GetCharArrayRegion)(JNIEnv *env, jcharArray array,
                                 jsize start, jsize len, jchar* buf);
void JNIFUNC(SetCharArrayRegion)(JNIEnv *env, jcharArray array,
                                 jsize start, jsize len, jchar* buf);
jshortArray JNIFUNC(NewShortArray)(JNIEnv *env, jsize length);
jshort* JNIFUNC(GetShortArrayElements)(JNIEnv *env, jshortArray array,
                                       jboolean* isCopy);
void JNIFUNC(ReleaseShortArrayElements)(JNIEnv *env, jshortArray array,
                                        jshort* elems, jint mode);
void JNIFUNC(GetShortArrayRegion)(JNIEnv *env, jshortArray array,
                                  jsize start, jsize len, jshort* buf);
void JNIFUNC(SetShortArrayRegion)(JNIEnv *env, jshortArray array,
                                  jsize start, jsize len, jshort* buf);
jintArray JNIFUNC(NewIntArray)(JNIEnv *env, jsize length);
jint* JNIFUNC(GetIntArrayElements)(JNIEnv *env, jintArray array,
                                   jboolean* isCopy);
void JNIFUNC(ReleaseIntArrayElements)(JNIEnv *env, jintArray array,
                                      jint* elems, jint mode);
void JNIFUNC(GetIntArrayRegion)(JNIEnv *env, jintArray array,
                                jsize start, jsize len, jint* buf);
void JNIFUNC(SetIntArrayRegion)(JNIEnv *env, jintArray array,
                                jsize start, jsize len, jint* buf);
jlongArray JNIFUNC(NewLongArray)(JNIEnv *env, jsize length);
jlong* JNIFUNC(GetLongArrayElements)(JNIEnv *env, jlongArray array,
                                     jboolean* isCopy);
void JNIFUNC(ReleaseLongArrayElements)(JNIEnv *env, jlongArray array,
                                       jlong* elems, jint mode);
void JNIFUNC(GetLongArrayRegion)(JNIEnv *env, jlongArray array,
                                 jsize start, jsize len, jlong* buf);
void JNIFUNC(SetLongArrayRegion)(JNIEnv *env, jlongArray array,
                                 jsize start, jsize len, jlong* buf);
jfloatArray JNIFUNC(NewFloatArray)(JNIEnv *env, jsize length);
jfloat* JNIFUNC(GetFloatArrayElements)(JNIEnv *env, jfloatArray array,
                                       jboolean* isCopy);
void JNIFUNC(ReleaseFloatArrayElements)(JNIEnv *env, jfloatArray array,
                                        jfloat* elems, jint mode);
void JNIFUNC(GetFloatArrayRegion)(JNIEnv *env, jfloatArray array,
                                  jsize start, jsize len, jfloat* buf);
void JNIFUNC(SetFloatArrayRegion)(JNIEnv *env, jfloatArray array,
                                  jsize start, jsize len, jfloat* buf);
jdoubleArray JNIFUNC(NewDoubleArray)(JNIEnv *env, jsize length);
jdouble* JNIFUNC(GetDoubleArrayElements)(JNIEnv *env, jdoubleArray array,
                                         jboolean* isCopy);
void JNIFUNC(ReleaseDoubleArrayElements)(JNIEnv *env, jdoubleArray array,
                                         jdouble* elems, jint mode);
void JNIFUNC(GetDoubleArrayRegion)(JNIEnv *env, jdoubleArray array,
                                   jsize start, jsize len, jdouble* buf);
void JNIFUNC(SetDoubleArrayRegion)(JNIEnv *env, jdoubleArray array,
                                   jsize start, jsize len, jdouble* buf);

jint JNIFUNC(RegisterNatives)(JNIEnv *env, jclass clazz,
                              const JNINativeMethod *methods, jint nMethods);
jint JNIFUNC(UnregisterNatives)(JNIEnv *env, jclass clazz);

jint JNIFUNC(MonitorEnter)(JNIEnv *env, jobject obj);
jint JNIFUNC(MonitorExit)(JNIEnv *env, jobject obj);

jint JNIFUNC(GetJavaVM)(JNIEnv *env, JavaVM **vm);

/* new for JDK 1.2 */

  /* local reference management */
jint JNIFUNC(EnsureLocalCapacity)(JNIEnv *env, jint capacity);
jint JNIFUNC(PushLocalFrame)(JNIEnv *env, jint capacity);
jobject JNIFUNC(PopLocalFrame)(JNIEnv *env, jobject result);
jobject JNIFUNC(NewLocalRef)(JNIEnv *env, jobject ref);

  /* weak global references */
jweak JNIFUNC(NewWeakGlobalRef)(JNIEnv *env, jobject obj);
void JNIFUNC(DeleteWeakGlobalRef)(JNIEnv *env, jweak obj);

  /* array operations */
void* JNIFUNC(GetPrimitiveArrayCritical)(JNIEnv *env, jarray array,
                                         jboolean *isCopy);
void JNIFUNC(ReleasePrimitiveArrayCritical)(JNIEnv *env,
                                            jarray array,
                                            void *carray, jint mode);

/* string operations */
void JNIFUNC(GetStringRegion)(JNIEnv *env, jstring str, jsize start,
                              jsize len, jchar *buf);
void JNIFUNC(GetStringUTFRegion)(JNIEnv *env, jstring str,
                                 jsize start, jsize len, char *buf);

const jchar* JNIFUNC(GetStringCritical)(JNIEnv *env, jstring string,
                                        jboolean *isCopy);
void JNIFUNC(ReleaseStringCritical)(JNIEnv *env, jstring string,
                                    const jchar *carray);

/* reflection support */
jmethodID JNIFUNC(FromReflectedMethod)(JNIEnv *env,
                                       jobject method);
jfieldID JNIFUNC(FromReflectedField)(JNIEnv *env,
                                     jobject field);
jobject JNIFUNC(ToReflectedMethod)(JNIEnv *env, jclass cls,
                                   jmethodID methodID);
jobject JNIFUNC(ToReflectedField)(JNIEnv *env, jclass cls,
                                  jfieldID fieldID);

PR_END_EXTERN_C

#endif /* _hungry_jniint_h */
