/* -*- Mode: C; c-file-style:"gnu"; indent-tabs-mode:nil -*- */
/* Definitions for using a zipped' archive.
   
   Copyright (c) 1996 Cygnus Support
   
   See the file "license.terms" for information on usage and redistribution
   of this file, and for a DISCLAIMER OF ALL WARRANTIES.
   
   Written by Per Bothner <bothner@cygnus.com>, February 1996.
*/

#ifndef _zipfile_h
#define _zipfile_h

#include "nspr.h"

PR_BEGIN_EXTERN_C

typedef struct ZipFile ZipFile;
typedef struct ZipDirectory ZipDirectory;

struct ZipFile {
  PRFileDesc* fd;
  long size;
  long count;
  long dir_size;
  char *central_directory;
  char *mmap_base;
  ZipDirectory** sorted_entries;
};

struct ZipDirectory {
  int direntry_size;
  int filename_offset;
  int zip_version; /* 16 bit */
  int compression_method;
  long compressed_size;
  long uncompressed_size;
  long filestart;  /* start of file in archive */
  long filename_length;
  /* char mid_padding[...]; */
  /* char filename[filename_length]; */
  /* char end_padding[...]; */
};

#define ZIPDIR_FILENAME(ZIPD) ((char*)(ZIPD)+(ZIPD)->filename_offset)
#define ZIPDIR_NEXT(ZIPD) \
((ZipDirectory*)((char*)(ZIPD)+(ZIPD)->direntry_size))


int read_zip_archive(ZipFile*);
void free_zipfile_entry(ZipDirectory*, PRUint8 *buf, PRUint32 length, PRBool malloced);
int get_zipfile_entry(ZipFile*, ZipDirectory*, PRUint8 **buf, PRUint32 *length, PRBool *malloced);

PR_END_EXTERN_C

#endif /* _zipfile_h */
