/* -*- Mode: C; c-file-style:"gnu"; indent-tabs-mode:nil -*-
   compat.h -- Definitions for substitute functions in arch/
   Created: Chris Toshok <toshok@hungry.com>, 23-Jul-97
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMPAT_H
#define COMPAT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "nspr.h"

PR_BEGIN_EXTERN_C

#include <sys/types.h>

int Alphasort(const void *a, const void *b);

int Scandir(const char *dir, PRDirEntry ***namelist,
	    int (*select)(const PRDirEntry *),
	    int (*compar)(const void *, const void *));

#ifndef HAVE_FMODF
float fmodf(float a, float b);
#endif

/* Might be missing on Windows */
#ifndef HAVE_SLEEP
unsigned int sleep(unsigned int seconds);
#endif

#ifdef HAVE_MMAP
#  ifdef HAVE_SYS_MMAN_H
#    include <sys/mman.h>
#  endif
#  ifndef MAP_FAILED
#    define MAP_FAILED ((char*)(-1))
#  endif
#endif

#ifndef HAVE_RESOLVEPATH
int resolvepath(const char *path, char *buf, size_t bufsize);
#endif

#ifndef HAVE_RINT
PR_EXTERN(double) rint(double d);
#endif

PR_END_EXTERN_C

#endif /* COMPAT_H */
