/* -*- Mode: C; c-file-style:"gnu"; indent-tabs-mode:nil -*-
   arch.h -- wrapper API for architecture dependant behaviour
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1999-08-07
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ARCH_H
#define ARCH_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "nspr.h"

PR_BEGIN_EXTERN_C

#ifdef _WINDOWS
#define PATH_SEPARATOR ";"
#define DIR_SEPARATOR "\\"
#else
#define PATH_SEPARATOR ":"
#define DIR_SEPARATOR "/"
#endif

/* These should mirror the constants set in the java Thread class */
#define JTHR_MAX_PRIORITY 10
#define JTHR_MIN_PRIORITY 1
#define JTHR_DEFAULT_PRIORITY 5

typedef void (*SIGNAL_handler)(int);

/*
 * Install handler to run when SIGBUS or SIGSEGV happends.  Signals is
 * restored to default before handler is called.
 */
void SIGNAL_install(SIGNAL_handler handler);

/* Dump core */
void SIGNAL_crash(void);

typedef void* HVMDllLibHandle;
typedef void* HVMDllFuncHandle;

/* Initialize the DLL handling.  Must be called once by each VM
   before calls to the other methods. Return 0 on success. */
PR_EXTERN(PRBool) HVM_DllInit(void);

/* Cleanup the DLL handling.  Must be called once when the VM
   exits. */
PR_EXTERN(void)   HVM_DllExit(void);

/* Load a shared object.  lib_path is presumed to be the full
   path name, including the extender. */
PR_EXTERN(HVMDllLibHandle)   HVM_DllLoad(char *lib_path);

/* Finds and loads a shared object.  The lookup strategy is
   architecture defined (unix platforms will probably use
   LD_LIBRARY_PATH).  lib_name is only the library name.  It
   does not include the extender or the path. */
PR_EXTERN(HVMDllLibHandle)   HVM_DllFind(char *lib_name);

/* Unloads a library. */
PR_EXTERN(void)              HVM_DllUnload(HVMDllLibHandle handle);

/* attempts to find a function in a specific library */
PR_EXTERN(HVMDllFuncHandle)  HVM_DllFindFunctionInLib(char *func_name,
                                                      HVMDllLibHandle handle);

/* Find a function in any of the shared objects loaded in
   as well in the executable. */
PR_EXTERN(HVMDllFuncHandle)  HVM_DllFindFunction(char *func_name);

/* Map from a japhar library name to a platform specific filename.
   e.g. lib_name = "zip" => libjaphar_zip.so (on freebsd)
*/
PR_EXTERN(char*) HVM_DllMapLibName(char *lib_name);

PR_END_EXTERN_C

#endif /* ARCH_H */
