/* -*- Mode: C; c-file-style: "gnu" -*-
   textfield.c -- native methods for sun/awt/motif/MTextFieldPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"
#include "common.h"

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>

#include <assert.h>
#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_create(JNIEnv *env,
					 jobject peer,
					 jobject parent_peer)
{
  Widget text;
  Widget parent;
  Arg av[10];
  int ac;

  parent = get_component_widget(env, parent_peer);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNhighlightThickness, 1); ac++;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;

  text = XmCreateTextField(parent,
			   "text",
			   av, ac);

  UNLOCK_AWT();

  set_component_widget(env, peer, text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_pSetEditable(JNIEnv *env,
					       jobject peer,
					       jboolean flag)
{
  Widget w = get_component_widget(env, peer);

  LOCK_AWT();
  XmTextFieldSetEditable(w, flag);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_select(JNIEnv *env,
					 jobject obj,
					 jint start,
					 jint length)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextFieldPeer_getSelectionStart(JNIEnv *env,
						    jobject obj)
{
  return 0;
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextFieldPeer_getSelectionEnd(JNIEnv *env,
						  jobject obj)
{
  return 0;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_setText(JNIEnv *env,
					  jobject peer,
					  jstring text)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  Widget w = get_component_widget(env, peer);
  char *text_str = HVM_StringToCString(henv, text);

  LOCK_AWT();
  XmTextFieldSetString(w, text_str);
  UNLOCK_AWT();

  free(text_str);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_insertReplaceText(JNIEnv *env,
						    jobject obj,
						    jstring text)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_preDispose(JNIEnv *env,
					     jobject obj)
{
}

JNIEXPORT jstring JNICALL
Java_sun_awt_motif_MTextFieldPeer_getText(JNIEnv *env,
					  jobject component_peer)
{
  Widget widget = get_component_widget(env, component_peer);
  char *str = XmTextGetString(widget);
  jstring ret_val;

  ret_val = (*env)->NewStringUTF(env, str);

  free(str);

  return ret_val;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_setEchoChar(JNIEnv *env,
					      jobject obj,
					      jchar echo_char)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_setFont(JNIEnv *env,
					  jobject obj,
					  jobject font)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MTextFieldPeer_setCaretPosition(JNIEnv *env,
						   jobject obj,
						   jint pos)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_motif_MTextFieldPeer_getCaretPosition(JNIEnv *env,
						   jobject obj)
{
  return 0;
}
