/* -*- Mode: C; c-file-style: "gnu" -*-
   offscreen.c -- native methods for sun/awt/image/OffScreenImageSource...
   Created: Chris Toshok <toshok@hungry.com>, 17-Oct-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"

#include "common.h"

void
Java_sun_awt_image_OffScreenImageSource_sendPixels(JNIEnv *env,
						   jobject obj)
{
  Pixmap pixmap;
  jfieldID width_field, height_field;
  jmethodID setPixels_method;
  jmethodID imageComplete_method;
  jclass image_consumer_cls;
  jbyteArray pixels;
  jint width, height;
  jint red_mask = 0xf800;
  jint green_mask = 0x7e0;
  jint blue_mask = 0x1f;
  jclass model_cls;
  jobject model;
  jmethodID ctor;
  jfieldID baseIR_field;
  jobject baseIR;
  jfieldID theConsumer_field;
  jobject theConsumer;

  printf ("OffscreenImageSource_sendPixels(IR = %p)\n", baseIR);

  baseIR_field = (*env)->GetFieldID(env, (*env)->GetObjectClass(env, obj),
				    "baseIR",
				    "Lsun/awt/image/ImageRepresentation;");
  baseIR = (*env)->GetObjectField(env, obj, baseIR_field);

  pixmap = (Pixmap)HVM_ObjectGetNativeState(baseIR);
  printf ("    pixmap = %d\n", pixmap);

  width_field = (*env)->GetFieldID(env, (*env)->GetObjectClass(env, obj),
				   "width", "I");
  height_field = (*env)->GetFieldID(env, (*env)->GetObjectClass(env, obj),
				    "height", "I");

  width = (*env)->GetIntField(env, obj, width_field);
  height = (*env)->GetIntField(env, obj, height_field);

  theConsumer_field = (*env)->GetFieldID(env, (*env)->GetObjectClass(env, obj),
					 "theConsumer",
					 "Ljava/awt/image/ImageConsumer;");
  theConsumer = (*env)->GetObjectField(env, obj, theConsumer_field);

  if (theConsumer == NULL)
    return; /* nothing to do */

  image_consumer_cls = (*env)->FindClass(env, "java/awt/image/ImageConsumer");
  setPixels_method = (*env)->GetMethodID(env, image_consumer_cls,
					 "setPixels",
					 "(IIIILjava/awt/image/ColorModel;[BII)V");
  imageComplete_method = (*env)->GetMethodID(env, image_consumer_cls,
					     "imageComplete",
					     "(I)V");

  model_cls = (*env)->FindClass(env, "java/awt/image/DirectColorModel");

  ctor = (*env)->GetMethodID(env, model_cls, "<init>",
			     "(IIII)V");

  model = (*env)->NewObject(env, model_cls, ctor, 
			    16, red_mask, green_mask, blue_mask);

  pixels = (*env)->NewByteArray(env, width * height);

  (*env)->CallVoidMethod(env, theConsumer, setPixels_method,
			     0, 0, width, height, model, pixels, 0, width);
  (*env)->CallVoidMethod(env, theConsumer, imageComplete_method, 3) /* XXX hardcoded STATICIMAGEDONE */;
}
