/* -*- Mode: C; c-file-style: "gnu" -*-
   menuitem.c -- native methods for sun/awt/motif/MMenuItemPeer..
   Created: Chris Toshok <toshok@hungry.com>, 9-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jniint.h"

#include "common.h"
#include <Xm/XmP.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>

static void
itemArmCallback(Widget w,
		XtPointer clientData,
		XtPointer callData)
{
}

static void
itemDisarmCallback(Widget w,
		   XtPointer clientData,
		   XtPointer callData)
{
}

static void
itemActivateCallback(Widget w,
		     XtPointer clientData,
		     XtPointer callData)
{
  JNIEnv *env = HVM_ThreadGetEnv()->thread_env;
  jobject peer = (jobject)clientData;
  jclass peer_cls = (*env)->GetObjectClass(env, peer);
  jfieldID target_field = (*env)->GetFieldID(env, peer_cls, "target", "Ljava/awt/MenuItem;");
  jobject target;
  jobject event_obj;
  jmethodID ctor;
  jint id = 1001; /* XXX we should get it from the static final field ACTION_PERFORMED. */
  jclass actionEventClass = (*env)->FindClass(env, "java/awt/event/ActionEvent");
  jclass toolkit_class = (*env)->FindClass(env, "sun/awt/motif/MToolkit");
  jmethodID postEvent;
  jstring action_cmd;

  ctor = (*env)->GetMethodID(env, actionEventClass, "<init>", "(Ljava/lang/Object;ILjava/lang/String;I)V");

  target = (*env)->GetObjectField(env, peer, target_field);

  action_cmd = (*env)->NewStringUTF(env, XtName(w));

  event_obj = (*env)->NewObject(env, actionEventClass,
				ctor, 
				/* 1 */ target,
				/* 2 */ id, /* event_id */
				/* 3 */ action_cmd,
				/* 4 */ 0 /* XXX modifiers */);

  postEvent = (*env)->GetStaticMethodID(env, toolkit_class,
					"postEvent",
					"(Ljava/awt/AWTEvent;)V");

  (*env)->CallStaticVoidMethod(env, toolkit_class, postEvent, event_obj);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuItemPeer_createMenuItem(JNIEnv *env,
						jobject peer,
						jobject parent_peer)
{
  Widget parent_widget = get_menuitem_widget(env, parent_peer);
  Widget menu_widget;
  Widget item_widget;
  char *label = get_menuitem_label(env, peer);
  XmString xmstr;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuItemPeer_createMenuItem()\n"));

  LOCK_AWT();

  XtVaGetValues(parent_widget,
		XmNsubMenuId, &menu_widget,
		NULL);

  if (!strcmp(label, "-")) /* XXX separator */
    {
      item_widget = XmCreateSeparatorGadget(menu_widget,
					    label,
					    NULL, 0);
    }
  else
    {
      xmstr = XmStringCreateSimple(label);
      
      item_widget = XmCreatePushButtonGadget(menu_widget,
					     "menuItem",
					     NULL, 0);
      
      XtVaSetValues(item_widget,
		    XmNlabelString, xmstr,
		    NULL);
      
      XmStringFree(xmstr);
      
      XtAddCallback(item_widget, XmNactivateCallback, itemActivateCallback, peer);
      XtAddCallback(item_widget, XmNarmCallback, itemArmCallback, peer);
      XtAddCallback(item_widget, XmNdisarmCallback, itemDisarmCallback, peer);
    }

  inherit_background_from(menu_widget, item_widget);

  XtManageChild(item_widget);

  UNLOCK_AWT();

  set_menuitem_widget(env, peer, item_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuItemPeer_pSetLabel(JNIEnv *env,
					   jobject peer,
					   jstring text)
{
  Widget widget = get_menuitem_widget(env, peer);
  const jbyte *label_text = (*env)->GetStringUTFChars(env, text, NULL);
  XmString label_xmstring;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuItemPeer_setLabel(peer = %p, text = %s)\n",
	   peer, label_text));

  LOCK_AWT();
  label_xmstring = XmStringCreate((char*)label_text, XmFONTLIST_DEFAULT_TAG);

  XtVaSetValues(widget,
		XmNlabelString, label_xmstring,
		NULL);

  XmStringFree(label_xmstring);
  UNLOCK_AWT();

  (*env)->ReleaseStringUTFChars(env, text, label_text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuItemPeer_pEnable(JNIEnv *env,
					 jobject peer)
{
  Widget widget = get_menuitem_widget(env, peer);

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuItemPeer_pEnable()\n"));

  LOCK_AWT();
  XtSetSensitive(widget, True);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuItemPeer_pDisable(JNIEnv *env,
					  jobject peer)
{
  Widget widget = get_menuitem_widget(env, peer);

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuItemPeer_pDisable()\n"));

  LOCK_AWT();
  XtSetSensitive(widget, False);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuItemPeer_pDispose(JNIEnv *env,
					  jobject peer)
{
  Widget widget = get_menuitem_widget(env, peer);

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuItemPeer_pDispose()\n"));

  LOCK_AWT();
  XtDestroyWidget(widget);
  UNLOCK_AWT();
}

