/* -*- Mode: C; c-file-style: "gnu" -*-
   menubar.c -- native methods for sun/awt/motif/MMenuBarPeer.
   Created: Chris Toshok <toshok@hungry.com>, 9-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"
#include "common.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuBarPeer_create(JNIEnv *env,
				       jobject peer,
				       jobject parent_peer)
{
  Widget menubar_widget, parent_widget;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuBarPeer_create()\n"));

  parent_widget = get_component_widget(env, parent_peer);

  LOCK_AWT();

  /*XXX XtParent hack since we know the widget layout of frames. */  
  menubar_widget = XmCreateMenuBar(XtParent(parent_widget),
				   "menu_bar", NULL, 0);

  inherit_background_from(parent_widget, menubar_widget);

  UNLOCK_AWT();

  set_menubar_widget(env, peer, menubar_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuBarPeer_dispose(JNIEnv *env,
					jobject peer)
{
  Widget menubar = get_menubar_widget(env, peer);

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuBarPeer_dispose()\n"));

  LOCK_AWT();
  XtDestroyWidget(menubar);
  UNLOCK_AWT();
}
