/* -*- Mode: C; c-file-style: "gnu" -*-
   menu.c -- native methods for sun/awt/motif/MMenuPeer.
   Created: Chris Toshok <toshok@hungry.com>, 9-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"
#include "common.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>

#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuPeer_createMenu(JNIEnv *env,
					jobject peer,
					jobject menubar_peer)
{
  Widget menubar_widget = get_menubar_widget(env, menubar_peer);
  Widget menu_widget;
  Widget cascade_widget;
  char *cascade_name = get_menuitem_label(env, peer);
  XmString cascade_labelstring;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuPeer_createMenu()\n"));

  LOCK_AWT();
  cascade_labelstring = XmStringCreate(cascade_name,
				       XmFONTLIST_DEFAULT_TAG);

  menu_widget = XmCreatePulldownMenu(menubar_widget,
				     "pulldown",
				     NULL, 0);

  inherit_background_from(menubar_widget, menu_widget);

  cascade_widget = XtVaCreateWidget("cascade",
				    xmCascadeButtonWidgetClass,
				    menubar_widget,
				    XmNlabelString, cascade_labelstring,
				    XmNsubMenuId, menu_widget,
				    NULL);

  inherit_background_from(menubar_widget, cascade_widget);

  XtManageChild(cascade_widget);

  XmStringFree(cascade_labelstring);
  UNLOCK_AWT();

  free(cascade_name);

  set_menuitem_widget(env, peer, cascade_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuPeer_createSubMenu(JNIEnv *env,
					   jobject peer,
					   jobject menu_peer)
{
  Widget parent_cascade_widget = get_menuitem_widget(env, menu_peer);
  Widget parent_menu_widget;
  Widget menu_widget;
  Widget cascade_widget;
  char *cascade_name = get_menuitem_label(env, peer);
  XmString cascade_labelstring;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("in sun_awt_motif_MMenuPeer_createSubMenu()\n"));

  LOCK_AWT();
  cascade_labelstring = XmStringCreate(cascade_name, XmFONTLIST_DEFAULT_TAG);

  XtVaGetValues(parent_cascade_widget,
		XmNsubMenuId, &parent_menu_widget,
		NULL);

  menu_widget = XmCreatePulldownMenu(parent_menu_widget,
				     "pulldown",
				     NULL, 0);

  inherit_background_from(parent_menu_widget, menu_widget);

  cascade_widget = XtVaCreateWidget("cascade",
				    xmCascadeButtonWidgetClass,
				    parent_menu_widget,
				    XmNlabelString, cascade_labelstring,
				    XmNsubMenuId, menu_widget,
				    NULL);

  inherit_background_from(parent_menu_widget, cascade_widget);
  
  XtManageChild(cascade_widget);
  XmStringFree(cascade_labelstring);
  UNLOCK_AWT();

  free(cascade_name);

  set_menuitem_widget(env, peer, cascade_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MMenuPeer_pDispose(JNIEnv *env,
				      jobject peer)
{
  Widget cascade_widget = get_menuitem_widget(env, peer);

  LOCK_AWT();
  XtDestroyWidget(cascade_widget);
  UNLOCK_AWT();
}
