/* -*- Mode: C; c-file-style: "gnu" -*-
   dialog.c -- native methods for sun/awt/motif/MDialogPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"

#include "common.h"
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>

#include <assert.h>
#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_create(JNIEnv *env,
				      jobject peer,
				      jobject parent_peer,
				      jobject obj)
{
  Widget dialog_widget, parent_widget;

  parent_widget = get_component_widget(env, parent_peer);

  LOCK_AWT();
  dialog_widget = XmCreateBulletinBoardDialog(parent_widget,
					      "dialog",
					      NULL, 0);
  inherit_background_from(parent_widget, dialog_widget);

  UNLOCK_AWT();

  set_component_widget(env, peer, dialog_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_pSetTitle(JNIEnv *env,
					 jobject peer,
					 jstring title)
{
  const jbyte *title_text;
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);
  title_text = (*env)->GetStringUTFChars(env, title, NULL);

  LOCK_AWT();
  XtVaSetValues(dialog_widget,
		XtNtitle, title_text,
		NULL);
  UNLOCK_AWT();

  (*env)->ReleaseStringUTFChars(env, title, title_text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_pShow(JNIEnv *env,
				     jobject peer)
{
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtManageChild(dialog_widget);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_pHide(JNIEnv *env,
				     jobject peer)
{
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtUnmanageChild(dialog_widget);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_pReshape(JNIEnv *env,
					jobject peer,
					jint x,
					jint y,
					jint width,
					jint height)
{
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtVaSetValues(dialog_widget,
		XmNx, x,
		XmNy, y,
		XmNwidth, width,
		XmNheight, height,
		NULL);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_pDispose(JNIEnv *env,
					jobject peer)
{
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtDestroyWidget(dialog_widget);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_setResizable(JNIEnv *env,
					    jobject peer,
					    jboolean flag)
{
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtVaSetValues(dialog_widget,
		XmNresizable, flag,
		NULL);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_addTextComponent(JNIEnv *env,
						jobject peer)
{
}


JNIEXPORT void JNICALL
Java_sun_awt_motif_MDialogPeer_toBack(JNIEnv *env,
				      jobject peer)
{
  Widget dialog_widget;

  dialog_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XLowerWindow(_awt_Display, XtWindow(XtParent(dialog_widget)));
  UNLOCK_AWT();
}
