/* -*- Mode: C; c-file-style: "gnu" -*-
   checkbox.c -- native methods for sun/awt/motif/MCheckboxPeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "jni.h"

#include "common.h"
#include <Xm/Xm.h>
#include <Xm/ToggleB.h>

#include <assert.h>
#include <stdlib.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MCheckboxPeer_create(JNIEnv *env,
					jobject peer,
					jobject parent_peer)
{
  Widget checkbox;
  Widget parent;
  Arg av[10];
  int ac;
  jboolean state;
  jstring label;
  char *label_str;
  XmString xmstr;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("In Java_sun_awt_motif_MCheckboxPeer_create\n"));

  assert(NULL != peer && NULL != parent_peer);

  parent = get_component_widget(env, parent_peer);

  label_str = get_checkbox_label(env, peer);

  LOCK_AWT();

  xmstr = XmStringCreateSimple(label_str);

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(av[ac], XmNlabelString, xmstr); ac++;

  checkbox = XmCreateToggleButton(parent,
				  "checkbox",
				  av, ac);

  XmStringFree(xmstr);

  inherit_background_from(parent, checkbox);

  UNLOCK_AWT();

  set_component_widget(env, peer, checkbox);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MCheckboxPeer_setLabel(JNIEnv *env,
					  jobject peer,
					  jstring text)
{
  Widget widget = get_component_widget(env, peer);
  const jbyte *label_text = (*env)->GetStringUTFChars(env, text, NULL);
  XmString label_xmstring;

  PR_LOG (awtLm, PR_LOG_DEBUG,
	  ("In Java_sun_awt_motif_MCheckboxPeer_setLabel\n"));

  LOCK_AWT();

  label_xmstring = XmStringCreate((char*)label_text, XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(widget,
		XmNlabelString, label_xmstring,
		NULL);

  XmStringFree(label_xmstring);

  UNLOCK_AWT();

  (*env)->ReleaseStringUTFChars(env, text, label_text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MCheckboxPeer_setState(JNIEnv *env,
					  jobject peer,
					  jboolean state)
{
  Widget widget = get_component_widget(env, peer);

  LOCK_AWT();
  XmToggleButtonSetState(widget, state, False);
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MCheckboxPeer_setCheckboxGroup(JNIEnv *env,
						  jobject peer,
						  jobject checkboxgroup)
{
}
