/* -*- Mode: C; c-file-style: "gnu" -*-
   nativewrapper.c -- native methods for sun/awt/font/NativeWrapper
   Created: Chris Toshok <toshok@hungry.com>, 24-Jan-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"

#include <stdlib.h>
#include <string.h>

JNIEXPORT jboolean JNICALL
Java_sun_awt_font_NativeFontWrapper_canDisplay
(JNIEnv *env, jclass cls, jobject font, jchar ch)
{
}

JNIEXPORT jboolean JNICALL
Java_sun_awt_font_NativeFontWrapper_doesGlyphShaping
(JNIEnv *env, jclass cls, jobject o)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes24BitBGR
(JNIEnv *env, jclass cls,
 jbyteArray byes, jint bytes_off, jint bytes_len,
 jfloat x, jfloat y,
 jobject font, jboolean flag,
 jdoubleArray arr, jint arr_off, jint arr_len,
 jint i, jint j, jint k, jobject o)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes24BitBGRRaster
(JNIEnv *env, jclass cls,
 jbyteArray bytes, jint bytes_off, jint bytes_len,
 jfloat x, jfloat y,
 jobject font,
 jboolean flag,
 jdoubleArray arr, jint arr_off, jint arr_len,
 jint i, jint j, jint k, jint l,
 jbyteArray b, jint b_off, jint b_len)
{
}

#if 0
JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes24BitRGB(JNIEnv *,
						      jclass,
						      jbyteArray,
						      jint,
						      jint,
						      jfloat,
						      jfloat,
						      jobject,
						      jboolean,
						      jdoubleArray,
						      jint,
						      jint,
						      jint,
						      jint,
						      jint,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes24BitRGBRaster(JNIEnv *,
							    jclass,
							    jbyteArray,
							    jint,
							    jint,
							    jfloat,
							    jfloat,
							    jobject,
							    jboolean,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jbyteArray,
							    jint,
							    jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes3Byte(JNIEnv *,
						   jclass,
						   jbyteArray,
						   jint,
						   jint,
						   jfloat,
						   jfloat,
						   jobject,
						   jdoubleArray,
						   jint,
						   jint,
						   jint,
						   jint,
						   jint,
						   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes3ByteRaster(JNIEnv *,
							 jclass,
							 jbyteArray,
							 jint,
							 jint,
							 jfloat,
							 jfloat,
							 jobject,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jbyteArray,
							 jint,
							 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes555(JNIEnv *,
						 jclass,
						 jbyteArray,
						 jint,
						 jint,
						 jfloat,
						 jfloat,
						 jobject,
						 jboolean,
						 jdoubleArray,
						 jint,
						 jint,
						 jint,
						 jint,
						 jint,
						 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes555Raster(JNIEnv *,
						       jclass,
						       jbyteArray,
						       jint,
						       jint,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jshortArray,
						       jint,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes565(JNIEnv *,
						 jclass,
						 jbyteArray,
						 jint,
						 jint,
						 jfloat,
						 jfloat,
						 jobject,
						 jboolean,
						 jdoubleArray,
						 jint,
						 jint,
						 jint,
						 jint,
						 jint,
						 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytes565Raster(JNIEnv *,
						       jclass,
						       jbyteArray,
						       jint,
						       jint,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jshortArray,
						       jint,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesARGB(JNIEnv *,
						  jclass,
						  jbyteArray,
						  jint,
						  jint,
						  jfloat,
						  jfloat,
						  jobject,
						  jboolean,
						  jdoubleArray,
						  jint,
						  jint,
						  jint,
						  jint,
						  jint,
						  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesARGBRaster(JNIEnv *,
							jclass,
							jbyteArray,
							jint,
							jint,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jint,
							jintArray,
							jint,
							jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesBGR(JNIEnv *,
						 jclass,
						 jbyteArray,
						 jint,
						 jint,
						 jfloat,
						 jfloat,
						 jobject,
						 jboolean,
						 jdoubleArray,
						 jint,
						 jint,
						 jint,
						 jint,
						 jint,
						 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesBGRRaster(JNIEnv *,
						       jclass,
						       jbyteArray,
						       jint,
						       jint,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jintArray,
						       jint,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesByteDiscrete(JNIEnv *,
							  jclass,
							  jbyteArray,
							  jint,
							  jint,
							  jfloat,
							  jfloat,
							  jobject,
							  jdoubleArray,
							  jint,
							  jint,
							  jint,
							  jint,
							  jint,
							  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesByteDiscreteRaster(JNIEnv *,
								jclass,
								jbyteArray,
								jint,
								jint,
								jfloat,
								jfloat,
								jobject,
								jdoubleArray,
								jint,
								jint,
								jint,
								jint,
								jint,
								jint,
								jbyteArray,
								jint,
								jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesByteGray(JNIEnv *,
						      jclass,
						      jbyteArray,
						      jint,
						      jint,
						      jfloat,
						      jfloat,
						      jobject,
						      jboolean,
						      jdoubleArray,
						      jint,
						      jint,
						      jint,
						      jint,
						      jint,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesIndex8Gray(JNIEnv *,
							jclass,
							jbyteArray,
							jint,
							jint,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesIndexed(JNIEnv *,
						     jclass,
						     jbyteArray,
						     jint,
						     jint,
						     jfloat,
						     jfloat,
						     jobject,
						     jboolean,
						     jdoubleArray,
						     jint,
						     jint,
						     jint,
						     jint,
						     jint,
						     jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesIntDiscrete(JNIEnv *,
							 jclass,
							 jbyteArray,
							 jint,
							 jint,
							 jfloat,
							 jfloat,
							 jobject,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesIntDiscreteRaster(JNIEnv *,
							       jclass,
							       jbyteArray,
							       jint,
							       jint,
							       jfloat,
							       jfloat,
							       jobject,
							       jdoubleArray,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jintArray,
							       jint,
							       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesShortDiscrete(JNIEnv *,
							   jclass,
							   jbyteArray,
							   jint,
							   jint,
							   jfloat,
							   jfloat,
							   jobject,
							   jdoubleArray,
							   jint,
							   jint,
							   jint,
							   jint,
							   jint,
							   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawBytesShortDiscreteRaster(JNIEnv *,
								 jclass,
								 jbyteArray,
								 jint,
								 jint,
								 jfloat,
								 jfloat,
								 jobject,
								 jdoubleArray,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jshortArray,
								 jint,
								 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars24BitBGR(JNIEnv *,
						      jclass,
						      jcharArray,
						      jint,
						      jint,
						      jfloat,
						      jfloat,
						      jobject,
						      jboolean,
						      jdoubleArray,
						      jint,
						      jint,
						      jint,
						      jint,
						      jint,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars24BitBGRRaster(JNIEnv *,
							    jclass,
							    jcharArray,
							    jint,
							    jint,
							    jfloat,
							    jfloat,
							    jobject,
							    jboolean,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jbyteArray,
							    jint,
							    jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars24BitRGB(JNIEnv *,
						      jclass,
						      jcharArray,
						      jint,
						      jint,
						      jfloat,
						      jfloat,
						      jobject,
						      jboolean,
						      jdoubleArray,
						      jint,
						      jint,
						      jint,
						      jint,
						      jint,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars24BitRGBRaster(JNIEnv *,
							    jclass,
							    jcharArray,
							    jint,
							    jint,
							    jfloat,
							    jfloat,
							    jobject,
							    jboolean,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jbyteArray,
							    jint,
							    jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars3Byte(JNIEnv *,
						   jclass,
						   jcharArray,
						   jint,
						   jint,
						   jfloat,
						   jfloat,
						   jobject,
						   jdoubleArray,
						   jint,
						   jint,
						   jint,
						   jint,
						   jint,
						   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars3ByteRaster(JNIEnv *,
							 jclass,
							 jcharArray,
							 jint,
							 jint,
							 jfloat,
							 jfloat,
							 jobject,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jbyteArray,
							 jint,
							 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars555(JNIEnv *,
						 jclass,
						 jcharArray,
						 jint,
						 jint,
						 jfloat,
						 jfloat,
						 jobject,
						 jboolean,
						 jdoubleArray,
						 jint,
						 jint,
						 jint,
						 jint,
						 jint,
						 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars555Raster(JNIEnv *,
						       jclass,
						       jcharArray,
						       jint,
						       jint,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jshortArray,
						       jint,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars565(JNIEnv *,
						 jclass,
						 jcharArray,
						 jint,
						 jint,
						 jfloat,
						 jfloat,
						 jobject,
						 jboolean,
						 jdoubleArray,
						 jint,
						 jint,
						 jint,
						 jint,
						 jint,
						 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawChars565Raster(JNIEnv *,
						       jclass,
						       jcharArray,
						       jint,
						       jint,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jshortArray,
						       jint,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsARGB(JNIEnv *,
						  jclass,
						  jcharArray,
						  jint,
						  jint,
						  jfloat,
						  jfloat,
						  jobject,
						  jboolean,
						  jdoubleArray,
						  jint,
						  jint,
						  jint,
						  jint,
						  jint,
						  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsARGBRaster(JNIEnv *,
							jclass,
							jcharArray,
							jint,
							jint,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jint,
							jintArray,
							jint,
							jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsBGR(JNIEnv *,
						 jclass,
						 jcharArray,
						 jint,
						 jint,
						 jfloat,
						 jfloat,
						 jobject,
						 jboolean,
						 jdoubleArray,
						 jint,
						 jint,
						 jint,
						 jint,
						 jint,
						 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsBGRRaster(JNIEnv *,
						       jclass,
						       jcharArray,
						       jint,
						       jint,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jintArray,
						       jint,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsByteDiscrete(JNIEnv *,
							  jclass,
							  jcharArray,
							  jint,
							  jint,
							  jfloat,
							  jfloat,
							  jobject,
							  jdoubleArray,
							  jint,
							  jint,
							  jint,
							  jint,
							  jint,
							  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsByteDiscreteRaster(JNIEnv *,
								jclass,
								jcharArray,
								jint,
								jint,
								jfloat,
								jfloat,
								jobject,
								jdoubleArray,
								jint,
								jint,
								jint,
								jint,
								jint,
								jint,
								jbyteArray,
								jint,
								jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsByteGray(JNIEnv *,
						      jclass,
						      jcharArray,
						      jint,
						      jint,
						      jfloat,
						      jfloat,
						      jobject,
						      jboolean,
						      jdoubleArray,
						      jint,
						      jint,
						      jint,
						      jint,
						      jint,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsIndex8Gray(JNIEnv *,
							jclass,
							jcharArray,
							jint,
							jint,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsIndexed(JNIEnv *,
						     jclass,
						     jcharArray,
						     jint,
						     jint,
						     jfloat,
						     jfloat,
						     jobject,
						     jboolean,
						     jdoubleArray,
						     jint,
						     jint,
						     jint,
						     jint,
						     jint,
						     jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsIntDiscrete(JNIEnv *,
							 jclass,
							 jcharArray,
							 jint,
							 jint,
							 jfloat,
							 jfloat,
							 jobject,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsIntDiscreteRaster(JNIEnv *,
							       jclass,
							       jcharArray,
							       jint,
							       jint,
							       jfloat,
							       jfloat,
							       jobject,
							       jdoubleArray,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jintArray,
							       jint,
							       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsShortDiscrete(JNIEnv *,
							   jclass,
							   jcharArray,
							   jint,
							   jint,
							   jfloat,
							   jfloat,
							   jobject,
							   jdoubleArray,
							   jint,
							   jint,
							   jint,
							   jint,
							   jint,
							   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawCharsShortDiscreteRaster(JNIEnv *,
								 jclass,
								 jcharArray,
								 jint,
								 jint,
								 jfloat,
								 jfloat,
								 jobject,
								 jdoubleArray,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jshortArray,
								 jint,
								 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector24BitBGR(JNIEnv *,
							    jclass,
							    jintArray,
							    jfloatArray,
							    jfloat,
							    jfloat,
							    jobject,
							    jboolean,
							    jdoubleArray,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector24BitBGRRaster(JNIEnv *,
								  jclass,
								  jintArray,
								  jfloatArray,
								  jfloat,
								  jfloat,
								  jobject,
								  jboolean,
								  jdoubleArray,
								  jdoubleArray,
								  jint,
								  jint,
								  jint,
								  jint,
								  jint,
								  jint,
								  jbyteArray,
								  jint,
								  jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector24BitRGB(JNIEnv *,
							    jclass,
							    jintArray,
							    jfloatArray,
							    jfloat,
							    jfloat,
							    jobject,
							    jboolean,
							    jdoubleArray,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector24BitRGBRaster(JNIEnv *,
								  jclass,
								  jintArray,
								  jfloatArray,
								  jfloat,
								  jfloat,
								  jobject,
								  jboolean,
								  jdoubleArray,
								  jdoubleArray,
								  jint,
								  jint,
								  jint,
								  jint,
								  jint,
								  jint,
								  jbyteArray,
								  jint,
								  jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector3Byte(JNIEnv *,
							 jclass,
							 jintArray,
							 jfloatArray,
							 jfloat,
							 jfloat,
							 jobject,
							 jdoubleArray,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector3ByteRaster(JNIEnv *,
							       jclass,
							       jintArray,
							       jfloatArray,
							       jfloat,
							       jfloat,
							       jobject,
							       jdoubleArray,
							       jdoubleArray,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jbyteArray,
							       jint,
							       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector555(JNIEnv *,
						       jclass,
						       jintArray,
						       jfloatArray,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector555Raster(JNIEnv *,
							     jclass,
							     jintArray,
							     jfloatArray,
							     jfloat,
							     jfloat,
							     jobject,
							     jboolean,
							     jdoubleArray,
							     jdoubleArray,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jshortArray,
							     jint,
							     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector565(JNIEnv *,
						       jclass,
						       jintArray,
						       jfloatArray,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVector565Raster(JNIEnv *,
							     jclass,
							     jintArray,
							     jfloatArray,
							     jfloat,
							     jfloat,
							     jobject,
							     jboolean,
							     jdoubleArray,
							     jdoubleArray,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jshortArray,
							     jint,
							     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorARGB(JNIEnv *,
							jclass,
							jintArray,
							jfloatArray,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorARGBRaster(JNIEnv *,
							      jclass,
							      jintArray,
							      jfloatArray,
							      jfloat,
							      jfloat,
							      jobject,
							      jboolean,
							      jdoubleArray,
							      jdoubleArray,
							      jint,
							      jint,
							      jint,
							      jint,
							      jint,
							      jint,
							      jintArray,
							      jint,
							      jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorBGR(JNIEnv *,
						       jclass,
						       jintArray,
						       jfloatArray,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorBGRRaster(JNIEnv *,
							     jclass,
							     jintArray,
							     jfloatArray,
							     jfloat,
							     jfloat,
							     jobject,
							     jboolean,
							     jdoubleArray,
							     jdoubleArray,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jintArray,
							     jint,
							     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorByteDiscrete(JNIEnv *,
								jclass,
								jintArray,
								jfloatArray,
								jfloat,
								jfloat,
								jobject,
								jdoubleArray,
								jdoubleArray,
								jint,
								jint,
								jint,
								jint,
								jint,
								jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorByteDiscreteRaster(JNIEnv *,
								      jclass,
								      jintArray,
								      jfloatArray,
								      jfloat,
								      jfloat,
								      jobject,
								      jdoubleArray,
								      jdoubleArray,
								      jint,
								      jint,
								      jint,
								      jint,
								      jint,
								      jint,
								      jbyteArray,
								      jint,
								      jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorByteGray(JNIEnv *,
							    jclass,
							    jintArray,
							    jfloatArray,
							    jfloat,
							    jfloat,
							    jobject,
							    jboolean,
							    jdoubleArray,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorIndex8Gray(JNIEnv *,
							      jclass,
							      jintArray,
							      jfloatArray,
							      jfloat,
							      jfloat,
							      jobject,
							      jboolean,
							      jdoubleArray,
							      jdoubleArray,
							      jint,
							      jint,
							      jint,
							      jint,
							      jint,
							      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorIndexed(JNIEnv *,
							   jclass,
							   jintArray,
							   jfloatArray,
							   jfloat,
							   jfloat,
							   jobject,
							   jboolean,
							   jdoubleArray,
							   jdoubleArray,
							   jint,
							   jint,
							   jint,
							   jint,
							   jint,
							   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorIntDiscrete(JNIEnv *,
							       jclass,
							       jintArray,
							       jfloatArray,
							       jfloat,
							       jfloat,
							       jobject,
							       jdoubleArray,
							       jdoubleArray,
							       jint,
							       jint,
							       jint,
							       jint,
							       jint,
							       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorIntDiscreteRaster(JNIEnv *,
								     jclass,
								     jintArray,
								     jfloatArray,
								     jfloat,
								     jfloat,
								     jobject,
								     jdoubleArray,
								     jdoubleArray,
								     jint,
								     jint,
								     jint,
								     jint,
								     jint,
								     jint,
								     jintArray,
								     jint,
								     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorShortDiscrete(JNIEnv *,
								 jclass,
								 jintArray,
								 jfloatArray,
								 jfloat,
								 jfloat,
								 jobject,
								 jdoubleArray,
								 jdoubleArray,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawGlyphVectorShortDiscreteRaster(JNIEnv *,
								       jclass,
								       jintArray,
								       jfloatArray,
								       jfloat,
								       jfloat,
								       jobject,
								       jdoubleArray,
								       jdoubleArray,
								       jint,
								       jint,
								       jint,
								       jint,
								       jint,
								       jint,
								       jshortArray,
								       jint,
								       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString24BitBGR(JNIEnv *,
						       jclass,
						       jstring,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString24BitBGRRaster(JNIEnv *,
							     jclass,
							     jstring,
							     jfloat,
							     jfloat,
							     jobject,
							     jboolean,
							     jdoubleArray,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jbyteArray,
							     jint,
							     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString24BitRGB(JNIEnv *,
						       jclass,
						       jstring,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString24BitRGBRaster(JNIEnv *,
							     jclass,
							     jstring,
							     jfloat,
							     jfloat,
							     jobject,
							     jboolean,
							     jdoubleArray,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jint,
							     jbyteArray,
							     jint,
							     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString3Byte(JNIEnv *,
						    jclass,
						    jstring,
						    jfloat,
						    jfloat,
						    jobject,
						    jdoubleArray,
						    jint,
						    jint,
						    jint,
						    jint,
						    jint,
						    jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString3ByteRaster(JNIEnv *,
							  jclass,
							  jstring,
							  jfloat,
							  jfloat,
							  jobject,
							  jdoubleArray,
							  jint,
							  jint,
							  jint,
							  jint,
							  jint,
							  jint,
							  jbyteArray,
							  jint,
							  jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString555(JNIEnv *,
						  jclass,
						  jstring,
						  jfloat,
						  jfloat,
						  jobject,
						  jboolean,
						  jdoubleArray,
						  jint,
						  jint,
						  jint,
						  jint,
						  jint,
						  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString555Raster(JNIEnv *,
							jclass,
							jstring,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jint,
							jshortArray,
							jint,
							jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString565(JNIEnv *,
						  jclass,
						  jstring,
						  jfloat,
						  jfloat,
						  jobject,
						  jboolean,
						  jdoubleArray,
						  jint,
						  jint,
						  jint,
						  jint,
						  jint,
						  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawString565Raster(JNIEnv *,
							jclass,
							jstring,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jint,
							jshortArray,
							jint,
							jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringARGB(JNIEnv *,
						   jclass,
						   jstring,
						   jfloat,
						   jfloat,
						   jobject,
						   jboolean,
						   jdoubleArray,
						   jint,
						   jint,
						   jint,
						   jint,
						   jint,
						   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringARGBRaster(JNIEnv *,
							 jclass,
							 jstring,
							 jfloat,
							 jfloat,
							 jobject,
							 jboolean,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jintArray,
							 jint,
							 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringBGR(JNIEnv *,
						  jclass,
						  jstring,
						  jfloat,
						  jfloat,
						  jobject,
						  jboolean,
						  jdoubleArray,
						  jint,
						  jint,
						  jint,
						  jint,
						  jint,
						  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringBGRRaster(JNIEnv *,
							jclass,
							jstring,
							jfloat,
							jfloat,
							jobject,
							jboolean,
							jdoubleArray,
							jint,
							jint,
							jint,
							jint,
							jint,
							jint,
							jintArray,
							jint,
							jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringByteDiscrete(JNIEnv *,
							   jclass,
							   jstring,
							   jfloat,
							   jfloat,
							   jobject,
							   jdoubleArray,
							   jint,
							   jint,
							   jint,
							   jint,
							   jint,
							   jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringByteDiscreteRaster(JNIEnv *,
								 jclass,
								 jstring,
								 jfloat,
								 jfloat,
								 jobject,
								 jdoubleArray,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jint,
								 jbyteArray,
								 jint,
								 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringByteGray(JNIEnv *,
						       jclass,
						       jstring,
						       jfloat,
						       jfloat,
						       jobject,
						       jboolean,
						       jdoubleArray,
						       jint,
						       jint,
						       jint,
						       jint,
						       jint,
						       jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringIndex8Gray(JNIEnv *,
							 jclass,
							 jstring,
							 jfloat,
							 jfloat,
							 jobject,
							 jboolean,
							 jdoubleArray,
							 jint,
							 jint,
							 jint,
							 jint,
							 jint,
							 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringIndexed(JNIEnv *,
						      jclass,
						      jstring,
						      jfloat,
						      jfloat,
						      jobject,
						      jboolean,
						      jdoubleArray,
						      jint,
						      jint,
						      jint,
						      jint,
						      jint,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringIntDiscrete(JNIEnv *,
							  jclass,
							  jstring,
							  jfloat,
							  jfloat,
							  jobject,
							  jdoubleArray,
							  jint,
							  jint,
							  jint,
							  jint,
							  jint,
							  jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringIntDiscreteRaster(JNIEnv *,
								jclass,
								jstring,
								jfloat,
								jfloat,
								jobject,
								jdoubleArray,
								jint,
								jint,
								jint,
								jint,
								jint,
								jint,
								jintArray,
								jint,
								jint)
{
}

JNIEXPORT jobject JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringOutline(JNIEnv *,
						      jclass,
						      jstring,
						      jfloat,
						      jfloat,
						      jobject,
						      jdoubleArray,
						      jboolean,
						      jboolean,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringShortDiscrete(JNIEnv *,
							    jclass,
							    jstring,
							    jfloat,
							    jfloat,
							    jobject,
							    jdoubleArray,
							    jint,
							    jint,
							    jint,
							    jint,
							    jint,
							    jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_drawStringShortDiscreteRaster(JNIEnv *,
								  jclass,
								  jstring,
								  jfloat,
								  jfloat,
								  jobject,
								  jdoubleArray,
								  jint,
								  jint,
								  jint,
								  jint,
								  jint,
								  jint,
								  jshortArray,
								  jint,
								  jint)
{
}

JNIEXPORT jfloat JNICALL
Java_sun_awt_font_NativeFontWrapper_getAdvance(JNIEnv *,
					       jclass,
					       jobject,
					       jchar,
					       jdoubleArray,
					       jboolean,
					       jboolean)
{
}

JNIEXPORT jstring JNICALL
Java_sun_awt_font_NativeFontWrapper_getFamilyName(JNIEnv *,
						  jclass,
						  jobject,
						  jshort)
{
}

JNIEXPORT jstring JNICALL
Java_sun_awt_font_NativeFontWrapper_getFamilyNameByIndex(JNIEnv *,
							 jclass,
							 jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_getFontMetrics(JNIEnv *,
						   jclass,
						   jobject,
						   jdoubleArray,
						   jboolean,
						   jboolean,
						   jfloatArray)
{
}
#endif

JNIEXPORT jstring JNICALL
Java_sun_awt_font_NativeFontWrapper_getFontPath(JNIEnv *env, jclass cls)
{
  return (*env)->NewStringUTF(env, "/usr/local/japhar/share/fonts"); /* XXX */
}

JNIEXPORT jstring JNICALL
Java_sun_awt_font_NativeFontWrapper_getFullName(JNIEnv *env,
						jclass cls,
						jobject foo,
						jshort foo2)
{
  return NULL;
}

JNIEXPORT jstring JNICALL
Java_sun_awt_font_NativeFontWrapper_getFullNameByFileName(JNIEnv *env,
							  jclass cls,
							  jstring filename)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  char *filename_str;
  printf ("in NativeFontWrapper.getFullNameByFileName()\n");

  filename_str = HVM_StringToCString(henv, filename);

  printf ("filename = %s\n", filename_str);

  return NULL;
}

#if 0
JNIEXPORT jstring JNICALL
Java_sun_awt_font_NativeFontWrapper_getFullNameByIndex(JNIEnv *,
						       jclass,
						       jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_getGlyphInfo(JNIEnv *,
						 jclass,
						 jobject,
						 jcharArray,
						 jint,
						 jint,
						 jdoubleArray,
						 jboolean,
						 jboolean,
						 jfloatArray)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_getGlyphJustificationInfo(JNIEnv *,
							      jclass,
							      jobject,
							      jint,
							      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_getGlyphMetrics(JNIEnv *,
						    jclass,
						    jobject,
						    jint,
						    jdoubleArray,
						    jboolean,
						    jboolean,
						    jobject)
{
}

JNIEXPORT jobject JNICALL
Java_sun_awt_font_NativeFontWrapper_getGlyphOutline(JNIEnv *,
						    jclass,
						    jobject,
						    jobject,
						    jdoubleArray,
						    jboolean,
						    jboolean,
						    jint,
						    jobject)
{
}

JNIEXPORT jobject JNICALL
Java_sun_awt_font_NativeFontWrapper_getGlyphVectorOutline(JNIEnv *,
							  jclass,
							  jobject,
							  jobject,
							  jdoubleArray,
							  jboolean,
							  jboolean,
							  jfloat,
							  jfloat,
							  jobject)
{
}

JNIEXPORT jfloat JNICALL
Java_sun_awt_font_NativeFontWrapper_getItalicAngle(JNIEnv *,
						   jclass,
						   jobject,
						   jdoubleArray,
						   jboolean,
						   jboolean)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_font_NativeFontWrapper_getMissingGlyphCode(JNIEnv *,
							jclass,
							jobject)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_font_NativeFontWrapper_getNumFonts(JNIEnv *,
						jclass)
{
}

JNIEXPORT jint JNICALL
Java_sun_awt_font_NativeFontWrapper_getNumGlyphs(JNIEnv *,
						 jclass,
						 jobject)
{
}
#endif

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_initializeFont(JNIEnv *env,
						   jclass wrapper_cls,
						   jobject font,
						   jstring str,
						   jint foo)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  char *str_str = HVM_StringToCString(henv, str);

  printf ("nativefontwrapper.initializeFont()\n");
  printf ("str == %s\n", str_str);
  printf ("foo == %d\n", foo);

  free(str_str);
}

#if 0
JNIEXPORT jboolean JNICALL
Java_sun_awt_font_NativeFontWrapper_isStyleSupported(JNIEnv *,
						     jclass,
						     jobject,
						     jint)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_layoutGlyphVector(JNIEnv *,
						      jclass,
						      jobject,
						      jdoubleArray,
						      jboolean,
						      jboolean,
						      jfloat,
						      jfloat,
						      jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_populateAndLayoutGlyphVector(JNIEnv *,
								 jclass,
								 jobject,
								 jcharArray,
								 jdoubleArray,
								 jboolean,
								 jboolean,
								 jfloat,
								 jfloat,
								 jobject)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_populateGlyphVector(JNIEnv *,
							jclass,
							jobject,
							jcharArray,
							jdoubleArray,
							jboolean,
							jboolean,
							jobject)
{
}
#endif

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_registerCompositeFont(JNIEnv *env,
							  jclass cls,
							  jstring foo,
							  jobjectArray foo2,
							  jintArray foo3,
							  jintArray foo4)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  char *foo_str;

  printf ("in NativeFontWrapper.registerCompositeFont()\n");

  foo_str = HVM_StringToCString(henv, foo);

  printf ("foo == %s\n", foo_str);
}

JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_registerFonts(JNIEnv *env,
						  jclass cls,
						  jobject o1,
						  jint i1,
						  jobject o2,
						  jint i2)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  jclass cls1, cls2;
  ClazzFile *cf1, *cf2;

  printf ("in NativeFontWrapper.registerFonts()\n");

  cls1 = (*env)->GetObjectClass(env, o1);
  cls2 = (*env)->GetObjectClass(env, o2);

  cf1 = jclass_to_clazzfile(henv, cls1);
  cf2 = jclass_to_clazzfile(henv, cls2);

  printf ("o1.cls = %s\n", getClassName(henv, cf1));
  printf ("o2.cls = %s\n", getClassName(henv, cf2));

  printf ("i1 = %d, i2 = %d\n", i1, i2);
}

#if 0
JNIEXPORT void JNICALL
Java_sun_awt_font_NativeFontWrapper_shapeGlyphVector(JNIEnv *,
						     jclass,
						     jobject,
						     jobject,
						     jdoubleArray,
						     jboolean,
						     jboolean,
						     jobject,
						     jobject)
{
}
#endif
