/* -*- Mode: C; c-file-style: "gnu" -*-
   unixproc.c -- native methods for java/lang/UNIXProcess.
   Created: Chris Toshok <toshok@hungry.com>, 28-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jniint.h"

#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

JNIEXPORT void JNICALL
Java_java_lang_UNIXProcess_run(JNIEnv *env,
			       jobject proc)
{
  (*env)->FatalError(env, "java.lang.UNIXProcess.run() unimplemented");
}

JNIEXPORT jlong JNICALL
Java_java_lang_UNIXProcess_forkAndExec(JNIEnv *env,
				       jobject proc,
				       jobjectArray proc_args,
				       jobjectArray proc_env)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  char **argv;
  char **envp;
  jsize argv_length = 0;
  jsize envp_length = 0;
  int i;
  pid_t child_pid;

  if (proc_args)
    argv_length = (*env)->GetArrayLength(env, proc_args);
  if (proc_env)
    envp_length = (*env)->GetArrayLength(env, proc_env);

  argv = (char**)malloc(argv_length + 1 /* for the NULL */);
  envp = (char**)malloc(envp_length + 1 /* for the NULL */);

  argv[argv_length] = NULL;
  envp[envp_length] = NULL;

  for (i = 0; i < argv_length; i ++)
    {
      jstring argv_str = (*env)->GetObjectArrayElement(env, proc_args, i);
      argv[i] = HVM_StringToCString(henv, argv_str);
    }

  for (i = 0; i < envp_length; i ++)
    {
      jstring envp_str = (*env)->GetObjectArrayElement(env, proc_args, i);
      envp[i] = HVM_StringToCString(henv, envp_str);
    }

  child_pid = fork();
  switch(child_pid)
    {
    case -1:
      /* this should probably be an exception... */
      (*env)->FatalError(env,
			 "java.lang.UNIXProcess.forkAndExec() - fork failed.");
      break;
    case 0:
      /* we're in the child. */
      execv(argv[0], (char**)argv);
      /* notreached */
      /* this should probably be an exception... */
      (*env)->FatalError(env,
			 "java.lang.UNIXProcess.forkAndExec() - exec failed.");
      break;
    default:
      /* we're in the parent. */
      for (i = 0; i < argv_length; i ++)
	free(argv[i]);
      free(argv);

      for (i = 0; i < envp_length; i ++)
	free(envp[i]);
      free(envp);

      break;
    }

  return child_pid;
}

/* JDK1.1 */
JNIEXPORT void JNICALL
Java_java_lang_UNIXProcess_notifyReaders(JNIEnv *env,
					 jobject proc)
{
  (*env)->FatalError(env, "java.lang.UNIXProcess.notifyReaders() unimplemented");
}

JNIEXPORT void JNICALL
Java_java_lang_UNIXProcess_destroy(JNIEnv *env,
				   jobject proc)
{
  (*env)->FatalError(env, "java.lang.UNIXProcess.destroy() unimplemented");
}

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_java_lang_UNIXProcess_initLockObject(JNIEnv *env,
					  jclass cls)
{
  (*env)->FatalError(env, "java.lang.UNIXProcess.initLockObject() unimplemented");
}
