/* -*- Mode: C; c-file-style: "gnu" -*-
   package.c -- native methods for java/lang/Package.
   Created: Chris Toshok <toshok@hungry.com>, 18-Nov-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jni.h"

#define MYLOG "Native"

static char* package_names[] = {
  "java/io/",
  "java/lang/",
  "java/lang/ref/",
  "java/lang/reflect/",
  "java/net/",
  "java/security/",
  "java/util/",
  "java/util/jar/",
  "java/util/zip/",
  "sun/io/",
  "sun/misc/",
  "sun/net/www/",
  "sun/net/www/protocol/file/",
  "sun/net/www/protocol/jar/",
  "sun/security/action/",
  "sun/security/provider/",
  "sun/security/util/"
};
static int num_packages = sizeof(package_names) / sizeof(package_names[0]);

JNIEXPORT jstring JNICALL
Java_java_lang_Package_getSystemPackage0(JNIEnv *env,
					 jclass cls,
					 jstring name)
{
  return (*env)->NewStringUTF(env, CLASSZIPDIR "/rt.jar");
}

JNIEXPORT jobjectArray JNICALL
Java_java_lang_Package_getSystemPackages0(JNIEnv *env,
					  jclass cls)
{
  jobjectArray package_array;
  int i;

  package_array = (*env)->NewObjectArray(env, num_packages,
					 (*env)->FindClass(env, "java/lang/String"),
					 NULL);
  
  for (i = 0; i < num_packages; i ++)
    (*env)->SetObjectArrayElement(env, package_array,
				  i, (*env)->NewStringUTF(env, package_names[i]));

  return package_array;
}
