/* -*- Mode: C; c-file-style: "gnu" -*-
   field.c -- native methods for java/lang/reflect/Field
   Created: Chris Toshok <toshok@hungry.com>, 12-Feb-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jniint.h"
#include "ClazzFile.h"
#include <stdlib.h>

#include "compat.h"

JNIEXPORT jint JNICALL
Java_java_lang_reflect_Method_getModifiers(JNIEnv *env,
					   jobject method)
{
  return (*env)->FromReflectedMethod(env, method)->access_flags;
}

JNIEXPORT jobject JNICALL
Java_java_lang_reflect_Method_invoke(JNIEnv *env,
				     jobject method,
				     jobject obj,
				     jobjectArray jargs)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  jmethodID methodID = (*env)->FromReflectedMethod(env, method);
  jobject ret = NULL;
  jvalue* args;
  char *rettype;

  /* probably need more checks here... */
  if (methodID->access_flags & ACC_PRIVATE)
    {
      HVM_ExceptionThrow(henv, "java/lang/IllegalAccessException",
  "in java.lang.reflect.Method.invoke, inaccessible method '%s' for class %s",
		      methodID->name, getClassName(henv, methodID->clazz));
      return NULL;
    }

  args = (jvalue*)objects_to_values(henv, jargs);
  rettype = HVM_SigFormatReturnTypeToC(henv,
				       HVM_SigParseFromJavaSig(henv, methodID->sig_str));

  if ( JSIG_VOID == *rettype )
    {
      if (methodID->access_flags & ACC_STATIC)
	{
	  (*env)->CallStaticVoidMethodA(env,
	    clazzfile_to_jclass(henv, methodID->clazz), methodID, args);
	}
      else
	{
	  (*env)->CallVoidMethodA(env,
	    clazzfile_to_jclass(henv, methodID->clazz), methodID, args);
	}
    }
  /* XXX how to I check if rettype is an object ? */
  else if ( JSIG_OBJECT == *rettype || JSIG_ARRAY == *rettype)
    {
      if (methodID->access_flags & ACC_STATIC)
	{
	  ret = (*env)->CallStaticObjectMethodA(env,
	    clazzfile_to_jclass(henv, methodID->clazz), methodID, args);
	}
      else
	{
	  ret = (*env)->CallObjectMethodA(env, obj, methodID, args);
	}
    }
  /* XXX Does not handle primitive return values */
  else
    {
      /* XXX Is this an accepted exception?  Check documentation! */
      HVM_ExceptionThrow(henv, "java/lang/reflect/InvocationTargetException",
		      "%s.%s: unhandled return type",
		      getClassName(henv, methodID->clazz),
		      methodID->name);
    }
  free(args);

  return ret;
}
