/* -*- Mode: C; c-file-style: "gnu" -*-
   constructor.c -- native methods for java/lang/reflect/Constructor
   Created: Chris Toshok <toshok@hungry.com>, 12-Feb-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jniint.h"
#include "ClazzFile.h"
#include "compat.h"
#include <stdlib.h>

JNIEXPORT jint JNICALL
Java_java_lang_reflect_Constructor_getModifiers(JNIEnv *env,
						jobject ctor)
{
  jmethodID ctorID = (*env)->FromReflectedMethod(env, ctor);
  return ctorID->access_flags;
}

JNIEXPORT jobject JNICALL
Java_java_lang_reflect_Constructor_newInstance(JNIEnv *env,
					       jobject ctor,
					       jobjectArray jargs)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  jmethodID ctorID = (*env)->FromReflectedMethod(env, ctor);
  jobject new_object;
  jvalue* args;

  /* probably need more checks here... */
  if (ctorID->access_flags & ACC_PRIVATE)
    {
      char buf[1024];
      PR_snprintf(buf, sizeof(buf),
		  "in java.lang.reflect.Constructor.newInstance, inaccessible constructor for class %s",
		  getClassName(env, ctorID->clazz));
      HVM_ExceptionThrow(henv, "java/lang/IllegalAccessException", buf);
      return NULL;
    }

  args = (jvalue*)objects_to_values(henv, jargs);
  new_object = (*env)->NewObjectA(env,
				  clazzfile_to_jclass(henv, ctorID->clazz), ctorID, args);
  free(args);

  return new_object;
}

/* For Classpath, not JDK */
JNIEXPORT jobject JNICALL
Java_java_lang_reflect_Constructor_constructNative(JNIEnv *env,
						   jobject ctor,
						   jobjectArray jargs,
						   jclass clazz,
						   jint slot)
{
  return(Java_java_lang_reflect_Constructor_newInstance(env, ctor, jargs));
}

/* For Classpath, not JDK */
JNIEXPORT jobjectArray JNICALL
Java_java_lang_reflect_Constructor_getParameterTypes(JNIEnv *env,
						     jobject ctor)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  HVM_ExceptionThrow(henv, "java/lang/UnsupportedOperationException",
		  "java.lang.reflect.Constructor.getParameterTypes()");

  return(0);
}

/* For Classpath, not JDK */
JNIEXPORT jobjectArray JNICALL
Java_java_lang_reflect_Constructor_getExceptionTypes(JNIEnv *env,
						     jobject ctor)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  HVM_ExceptionThrow(henv, "java/lang/UnsupportedOperationException",
		  "java.lang.reflect.Constructor.getExceptionTypes()");

  return(0);
}

