/* -*- Mode: C; c-file-style: "gnu" -*-
   objistrm.c -- native methods for java/io/ObjectInputStream.
   Created: Chris Toshok <toshok@hungry.com>, 27-Apr-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jniint.h"
#include <stdlib.h>
#include <string.h>

jobject 
Java_java_io_ObjectInputStream_loadClass0(JNIEnv *env, 
					  jobject strm, 
					  jobject cls, 
					  jstring classname )
{
  /* XXX this should be a lot smarter about the classloader it uses:
     if cls is not null, it should load classname using the same classloader.
     if cls is null, it should look up the stack for the nearest classloader and use
     that.
     if all else fails, use the primordial classloader.
     
     we just punt for now and use the primordial classloader.
  */
  jclass clazz_loaded;
  char *cls_name;
  int cls_name_length;
  const jbyte *cls_name_bytes;

  cls_name_bytes = (*env)->GetStringUTFChars(env, classname, NULL);

  cls_name_length = (*env)->GetStringUTFLength(env, classname) + 1;
  cls_name = (char*)malloc(cls_name_length * sizeof(char));

  strncpy(cls_name, (char*)cls_name_bytes, cls_name_length);

  (*env)->ReleaseStringUTFChars(env, classname, cls_name_bytes);

  slashes_to_dots(cls_name);

  clazz_loaded = (*env)->FindClass(env, cls_name);

  free(cls_name);

  if ((*env)->ExceptionOccurred(env))
    return NULL;
  else
    return clazz_loaded;
}

void 
Java_java_io_ObjectInputStream_inputClassFields(JNIEnv *env,
						jobject obj,
						jobject obj1,
						jobject obj2,
						jintArray arr)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  jclass class1, class2;
  ClazzFile *cf1, *cf2;

  class1 = (*env)->GetObjectClass(env, obj1);
  class2 = (*env)->GetObjectClass(env, obj2);

  cf1 = jclass_to_clazzfile(henv, class1);
  cf2 = jclass_to_clazzfile(henv, class2);
  
  printf("obj1 is type '%s'\n", getClassName(henv, cf1));
  printf("obj2 is type '%s'\n", getClassName(henv, cf2));

  (*env)->FatalError(env, "Java_java_io_ObjectInputStream_inputClassFields is not implemented.");
}

jobject 
Java_java_io_ObjectInputStream_allocateNewObject(JNIEnv *env,
						 jclass cls,
						 jobject obj1,
						 jobject obj2)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  jclass class1, class2;
  ClazzFile *cf1, *cf2;

  class1 = (*env)->GetObjectClass(env, obj1);
  class2 = (*env)->GetObjectClass(env, obj2);

  cf1 = jclass_to_clazzfile(henv, class1);
  cf2 = jclass_to_clazzfile(henv, class2);
  
  printf("obj1 is type '%s'\n", getClassName(henv, cf1));
  printf("obj2 is type '%s'\n", getClassName(henv, cf2));

  (*env)->FatalError(env, "Java_java_io_ObjectInputStream_allocateNewObject is not implemented.");
  return NULL;
}

jobject 
Java_java_io_ObjectInputStream_allocateNewArray(JNIEnv *env,
						jclass cls,
						jobject obj,
						jint i)
{
  (*env)->FatalError(env, "Java_java_io_ObjectInputStream_allocateNewArray is not implemented.");
  return NULL;
}

jboolean 
Java_java_io_ObjectInputStream_invokeObjectReader(JNIEnv *env,
						  jobject obj,
						  jobject obj1,
						  jobject obj2)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  jclass class1, class2;
  ClazzFile *cf1, *cf2;

  class1 = (*env)->GetObjectClass(env, obj1);
  class2 = (*env)->GetObjectClass(env, obj2);

  cf1 = jclass_to_clazzfile(henv, class1);
  cf2 = jclass_to_clazzfile(henv, class2);
  
  printf("obj1 is type '%s'\n", getClassName(henv, cf1));
  printf("obj2 is type '%s'\n", getClassName(henv, cf2));

  (*env)->FatalError(env, "Java_java_io_ObjectInputStream_invokeObjectReader is not implemented.");
  return JNI_FALSE;
}
