/* -*- Mode: C; c-file-style: "gnu" -*-
   filein.c -- native methods for java/io/FileInputStream.
   Created: Chris Toshok <toshok@hungry.com>, 30-Oct-1997.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "jniint.h"
#include "file.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef HAVE_IO_H
#  include <io.h>
#endif

/* JDK 1.2 */
JNIEXPORT void JNICALL
Java_java_io_FileInputStream_initIDs(JNIEnv *env,
				     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_io_FileInputStream_open(JNIEnv *env,
				  jobject obj,
				  jstring name)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  file_open(henv, obj, name, O_RDONLY);
}

JNIEXPORT jint JNICALL
Java_java_io_FileInputStream_read(JNIEnv *env,
				  jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  return file_read(henv, obj);
}

JNIEXPORT jint JNICALL
Java_java_io_FileInputStream_readBytes(JNIEnv *env,
				       jobject obj,
				       jbyteArray array,
				       jint offset,
				       jint length)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  return file_readBytes(henv, obj, array, offset, length);
}

JNIEXPORT jlong JNICALL
Java_java_io_FileInputStream_skip(JNIEnv *env,
				  jobject obj,
				  jlong skip_amount)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  int fd = get_file_descriptor(henv, obj);
  off_t pos = 0, newpos = 0;
  pos = lseek(fd, 0, SEEK_CUR);
  newpos = lseek(fd, skip_amount, SEEK_CUR);

  if (-1 == pos || -1 == newpos)
    {
      HVM_ExceptionThrow(henv, "java/io/IOException", "lseek() failed");
      return -1;
    }

  return newpos - pos;
}

JNIEXPORT jint JNICALL
Java_java_io_FileInputStream_available(JNIEnv *env,
				       jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  int fd = get_file_descriptor (henv, obj);
  int position;
  struct stat stat_buf;

  fstat (fd, &stat_buf);
  position = lseek (fd, 0, SEEK_CUR);
  return stat_buf.st_size - position;
}

JNIEXPORT void JNICALL
Java_java_io_FileInputStream_close(JNIEnv *env,
				   jobject obj)
{
  HungryEnv *henv = HVM_ThreadGetEnv();
  file_close(henv, obj);
}
