/* -*- Mode: C; c-file-style: "gnu" -*-
   common.h -- common methods for java/io/File...
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1998-05-21
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMMON_H
#define COMMON_H

#include "jniint.h"
#include "config.h"

#include <sys/types.h>
#include <sys/stat.h>

extern int get_file_descriptor(HungryEnv *henv, jobject input_stream);
extern void set_file_descriptor(HungryEnv *henv, jobject input_stream, int fd_int);
extern void file_open(HungryEnv *henv, jobject obj, jstring name, int flags);
extern void file_close(HungryEnv *henv, jobject obj);
extern jint file_read(HungryEnv *henv, jobject obj);
extern jint file_readBytes(HungryEnv *henv, jobject obj, jbyteArray array, jint
			   offset, jint length);
extern void file_write(HungryEnv *henv, jobject obj, jint byte);
extern void file_writeBytes(HungryEnv *henv, jobject obj, jbyteArray array, jint
			    offset, jint length);
extern int stat_file(HungryEnv *henv, jobject obj, struct stat *buf);
extern char *get_file_path(HungryEnv *henv, jobject obj);

#endif /* COMMON_H */
