/* -*- Mode: C; c-file-style: "gnu" -*-
   jvmdiint.c -- Internal Hungry methods for the JVMDI interface.
   Created: Chris Toshok <toshok@hungry.com>, 16-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef JVMDI_INTERNAL_H
#define JVMDI_INTERNAL_H

#include "jvmdi.h"
#include "jniint.h"

JNIEXPORT void JNICALL jvmdi_SingleStepEvent(HungryEnv *env, jthread thread,
					     jclass clazz, jmethodID method,
					     jint bci);

JNIEXPORT void JNICALL jvmdi_BreakpointEvent(HungryEnv *env, jthread thread,
					     jclass clazz, jmethodID method,
					     jint bci);
  
JNIEXPORT void JNICALL jvmdi_FramePopEvent(HungryEnv *env, jthread thread,
					   jframeID frame);
  
JNIEXPORT void JNICALL jvmdi_ExceptionEvent(HungryEnv *env, jthread thread,
					    jclass clazz, jmethodID method,
					    jint bci, jobject exception,
					    jclass catch_clazz, jmethodID catch_method,
					    jint catch_bci);

JNIEXPORT void JNICALL jvmdi_UserEvent(HungryEnv *env, jobject object,
				       jint key);

JNIEXPORT void JNICALL jvmdi_ThreadEndEvent(HungryEnv *env, jthread thread);

JNIEXPORT void JNICALL jvmdi_ThreadStartEvent(HungryEnv *env, jthread thread);

HungryEnv *thread_obj_to_jthread(HungryEnv *env, japhar_object* thread_obj);

#endif /* JVMDI_INTERNAL_H */
