/* -*- Mode: C; c-file-style:"gnu"; indent-tabs-mode:nil -*-
   qop.h -- basic queue (doubly linked list) operations. 
   Created: Chris Toshok <toshok@hungry.com>, 10-Aug-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _qop_h
#define _qop_h

/* Remove item previously placed in queue */
#define UNQUEUE(item, queue) \
do {\
      if ((queue) == (item)) (queue) = (item)->next; \
      if ((item)->next) (item)->next->prev = (item)->prev; \
      if ((item)->prev) (item)->prev->next = (item)->next; \
      (item)->next = NULL; \
      (item)->prev = NULL; \
} while (0)

/* Place item first in queue */
#define ENQUEUE(item, queue) \
do { \
       PR_ASSERT(NULL == item->next || "insert item once only"); \
       if ((queue)) (queue)->prev = (item); \
       (item)->next = (queue); \
       (item)->prev = NULL; \
       (queue) = (item); \
} while (0)

/* Return and remove last element of the list */
#define DEQUEUE(lastitem, queue) \
do { \
       lastitem = queue; \
       while (lastitem && lastitem->next) lastitem = lastitem->next; \
       if (lastitem == queue) queue = NULL; \
       else lastitem->prev->next = NULL; \
} while (0)

#ifdef TEST /* Runtime testing */

typedef struct item {
  struct item *prev, *next;
  int value;
} item_t;

void
output_list(item_t *list)
{
  printf("List:");
  while (list) {
    printf(" %d", list->value);
    list = list->next;
  }
  printf("\n");
}

item_t *
new_item(int value)
{
  item_t *item = PR_CALLOC(1, sizeof(item_t));
  item->value = value;
  return item;
}

int
main(int argc, char **argv)
{
  item_t *list = NULL;
  item_t *item;
  item = new_item(1); ENQUEUE(item, list);
  item = new_item(2); ENQUEUE(item, list);
  item = new_item(0); ENQUEUE(item, list);

  output_list(list);
  UNQUEUE(item, list);
  output_list(list);

  DEQUEUE(item, list);  output_list(list);
  DEQUEUE(item, list);  output_list(list);
  DEQUEUE(item, list);  output_list(list);

  return 0;
}
#endif /* TEST */

#endif /* _qop_h */
