/* -*- Mode: C; c-file-style:"gnu"; indent-tabs-mode:nil -*-
   resolvepath.c -- if resolvepath() is missing, make a replacement
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1999-07-19
*/
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef HAVE_RESOLVEPATH

#include <limits.h>

#include "plstr.h"
#include "compat.h"

/*
 * Change relative filename to full pathname.
 * return length of resulting path
 */
int 
resolvepath(const char *path, char *buf, size_t bufsize)
{
#ifdef HAVE_REALPATH
  char buffer[PATH_MAX];
  if ( NULL != realpath(path, buffer) )
    {
      size_t pathlen = PL_strlen(buffer);
      if (bufsize < pathlen)
	return (-1);
      else
	{
	  PL_strcpy(buf, buffer);
	  return pathlen;
	}
    }
  return (-1);
#else
  /* punt and don't transform the name at all */
  PL_strncpy(buf, path, bufsize);
  return PL_strlen(path);
#endif
}
#endif /* HAVE_RESOLVEPATH */
