#! /bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/portfw.sh - ip port forwarding

state=$1                                        # "up" or "down"
ip=$2                                           # ip address of wan interface

client1=192.168.1.1                             # ip of PC in LAN: change here!
#client2=192.168.1.2                            # ip of PC in LAN: change here!
#client3=192.168.1.3                            # ip of PC in LAN: change here!

if [ "$state" = "down" ]                        # state is down ...
then
    echo "shutting down port forwarding ..."

else
    echo "initializing port forwarding ..."
fi

/usr/sbin/ipmasqadm portfw -f                   # ipportfw: clear old tables
/usr/sbin/ipmasqadm autofw -F                   # ipautofw: flush old tables

if [ "$state" = "down" ]                        # state is down: exit here

then
    exit 0
fi

/usr/sbin/ipmasqadm autofw -A -v -r tcp 80 80 -h $client1

# www.ww      = Server auf den upgeloaded werden soll
# uuu         = Username
# ppp         = Password
#            = Die Variable die in der Vorlage durch die IP ersetzt werden soll
# vorlage.txt = Die im html-Code verfasste Vorlage
# cd verz     = "verz" ist das Verzeichnis auf dem FTP-Server 
# dynip.html  = So heisst das Dokument dann auf dem Server
  
echo "machine www.ww login uuu password ppp" > /.netrc
       chmod 600 /.netrc
       sed 's//'$ip'/g' /usr/local/bin/vorlage.txt > /tmp/datei.txt
       (echo "cd verz"; echo "send /tmp/datei.txt dynip.htm"; echo "bye" ) |
       ftp www.ww
    rm /tmp/datei.txt

echo 'done'
exit 0
