#!/bin/sh
# get main helper functions
. /srv/www/include/cgi-helper

. /var/run/vnstat.cfg

vnstat="$vnstattext"


http_status_header ()
{  # Output Header

case "$1" in
""|html)
    cat << EOF
Content-Type: text/html; charset=iso-8859-1
Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate, no-store
Pragma: no-cache
EOF
    echo "Expires: `date -Ru`"
    echo
;;

htmlstatic)
    cat << EOF
    Content-Type: text/html; charset=iso-8859-1
    Cache-control: max-age=3600
EOF
;;

download)
    eval $2
    : ${ctype:=application/download}
    : ${filename:=file.txt}
    echo "Content-Type: $ctype"
    echo "Content-Disposition: attachment; filename=$filename"
    echo
;;

csv)
    cat << EOF
Content-Type: text/csv; charset=iso-8859-1
Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate, no-store
Pragma: no-cache
EOF
    echo "Expires: `date -Ru`"
    echo
;;

404)
    echo "HTTP/1.1 404 Not Found"
    echo
;;
esac
}


http_status_header

# set default values
if [ "$FORM_range" == "" ]; then
  FORM_range="current"
fi

if [ "$FORM_interface" == "" ]; then
  FORM_interface="eth0"
fi


# TODO: return 404 for invalid interface or time range
allInterfaces=`$vnstat --iflist | cut -d":" -f2 | sed 's/^[ ]*//'`
if [ `expr "$allInterfaces" : ".*$FORM_interface.*"` == 0 ]; then
  show_error "Invalid Interface" "Interface $FORM_interface is not a valid network interface"
  exit 1
fi


# show csv output for selected interface and time range
case $FORM_range in
  hours)    vnstat_range="^h;"
            ;;
  days)     vnstat_range="^d;"
            ;;
  months)   vnstat_range="^m;"
            ;;
  top10)    vnstat_range="^t;"
            ;;
  current)  # /proc/net/dev data  format: http://linuxdevcenter.com/linux/2000/11/16/example1.html
            timestamp=`date +%s`

            interfaceData=`grep $FORM_interface /proc/net/dev | sed -e "s/^ *//g" -e "s/  */:/g" -e "s/::*/:/g"`
            traffInByte=`echo $interfaceData | cut -d':' -f2`
            traffOutByte=`echo $interfaceData | cut -d':' -f10`

            traffInKByte=`echo "scale=2; $traffInByte / 1024" |bc`
            traffOutKByte=`echo "scale=2; $traffOutByte / 1024" |bc`
            echo "$FORM_interface;$timestamp;$traffInByte;$traffOutByte;$traffInKByte;$traffOutKByte"
            ;;
  *)        # TODO return 404 for invalid time range
            ;;
esac

$vnstat -i $FORM_interface --exportdb | grep $vnstat_range
