//we may not use UTC time, otherwise we get time shifts 
//http://www.highcharts.com/ref/#global--useUTC
Highcharts.setOptions({
	global: {
		useUTC: false
	}
});

var titles = {
  "rx" : 'Received Data',
  "tx" : 'Sent Data',
  "avg(rx)" : 'Average Received',
  "avg(tx)" : 'Average Sent',
  "total" : 'Total Data'
};

//change default colors (reverse defaults)
/*
Highcharts.setOptions({
	colors: [
	'#B5CA92',
	'#A47D7C', 
	'#92A8CD', 
	'#DB843D', 
	'#3D96AE', 
	'#80699B', 
	'#89A54E', 
	'#AA4643', 
	'#4572A7']
});

Highcharts.setOptions({
	colors: [
	'#99C8AC', //34AD5C
	'#CF6B87', //612827
	'#527B63', //27613A
	'#82364C', //AD2623 
	'#B5CA92', 
	'#A47D7C', 
	'#89A54E', 
	'#AA4643', 
	'#4572A7']
});
*/

Highcharts.setOptions({
	colors: [
	'#74AF8D', //hellgrn
	'#AF7874', //hellrot
	'#376249', //dunkelgrn
	'#B94C69', //dunkelrot 
	'#B5CA92', 
	'#A47D7C', 
	'#89A54E', 
	'#AA4643', 
	'#4572A7']
});


/**
 * Options for live traffic chart 
 */
var liveTrafficOptions = {
	chart: {
		renderTo: 'liveData',
		events: {
			load: updateLiveData
		}
	},
	title: {
		text: 'Live Traffic '
	},
	xAxis: {
		type: 'datetime'
	},
	yAxis: {
		title: {
			text: 'Bytes'
		}
	},
	tooltip: {
		shared: true,
		crosshairs: true,
		formatter: function() {
			var s = '<b>' + Highcharts.dateFormat('%H:%M:%S', this.points[0].x) +'</b><br/>';
			for(var index in this.points) {
				var seriesTitle = titles[this.points[index].series.name];
				s += '<span style="color:'+this.points[index].series.color+'">'+seriesTitle+' ('+this.points[index].series.name+')</span>: '+ 
					getValueAndUnit(Math.abs(this.points[index].y)) +'<br/>';
			}
			return s;
		}
	},
	series: [{
//		type: 'column',
		type: 'line',
		step: true,
		name: 'rx',
		data: []
	},
	{
//		type: 'column',
		type: 'line',
		step: true,
		name: 'tx',
		data: []
	},
	{
		type: 'spline',
		name: 'avg(rx)',
		data: []
	},
	{
		type: 'spline',
		name: 'avg(tx)',
		data: []
	},
	{
		type: 'pie',
		name: 'Total',
		dataLabels: {
			formatter: function() {
				return this.percentage > 5 ? 
				'<p style="font-size:8pt">' + Highcharts.numberFormat(this.percentage, 2) + '% <br/>' + this.point.name + '</p>' : 
				null;
			},
			color: 'white',
			distance: -20
		},
		data: [{
			name: 'RX'
		}, {
			name: 'TX'
		}],
		center: [100, 20],
		size: 80,
		showInLegend: false,
		dataLabels: {
			enabled: false
		}
	}]
};


/**
 * Options for hourly, daily and monthly bar charts 
 */
var barOptions = {
	chart: {
		renderTo: 'columnChart',
		type: 'column'
	},
	title: {
		text: 'RX/TX Traffic'
	},
	xAxis: {
		type: 'datetime',
		title: {
			text: 'Date'
		}
	},
	yAxis: {
		title: {
			text: 'Bytes'
		},
		labels: {
			formatter: function() {
				vu = getValueAndUnitArray(Math.abs(this.value));
				return vu[0] + "<br/>" + (vu[1] == null?"":vu[1]);
			}
		}
	},
	series: [],
	tooltip: {
		shared: true,
		crosshairs: true,
		formatter: function(){
		var s = 'unknown';
		if(this.points.length == 2) {
			var series0Title = titles[this.points[0].series.name];
			var series1Title = titles[this.points[1].series.name];
			var totalTitle = titles['total'];
			s = '<b>' + Highcharts.dateFormat(dateFormat, this.points[0].x) +'</b><br/>'+		
				'<span style="color:'+this.points[0].series.color+'">'+series0Title+' ('+this.points[0].series.name+')</span>: '+ getValueAndUnit(Math.abs(this.points[0].y)) +'<br/>'+
				'<span style="color:'+this.points[1].series.color+'">'+series1Title+' ('+this.points[1].series.name+')</span>: '+ getValueAndUnit(Math.abs(this.points[1].y)) +'<br/>'+
				totalTitle+': '+ getValueAndUnit(Math.abs(this.points[0].y) + Math.abs(this.points[1].y)) +'<br/>';
		} else if(this.points.length == 1){
			var seriesTitle = titles[this.points[0].series.name];
			s = '<b>' + Highcharts.dateFormat(dateFormat, this.points[0].x) +'</b><br/>'+
				'<span style="color:'+this.points[0].series.color+'">'+seriesTitle+' ('+this.points[0].series.name+')</span>: '+ getValueAndUnit(Math.abs(this.points[0].y)) +'<br/>';		
		}
		return s;
		}
	}
};

barOptions.plotOptions = {
	series: {
		stacking: 'normal',
	}
};

/**
 * Options for hourly, daily and monthly negative bar charts 
 */
var negativeBarOptions = jQuery.extend(true, {}, barOptions);
negativeBarOptions.chart.renderTo = 'barChart';
negativeBarOptions.chart.type = 'bar';
negativeBarOptions.plotOptions = {
	series: {
		stacking: 'normal',
	}
};
			
negativeBarOptions.xAxis = [{
		type: 'datetime',
		dateTimeLabelFormats: {
			day: '%e. %b %y'   
		},
		reversed: false,
		title: {
				text: 'Date'
		}
	}, { // mirror axis on right side
		type: 'datetime',
		dateTimeLabelFormats: {
			day: '%e. %b %y'   
		},
		opposite: true,
		reversed: false,
		linkedTo: 0,
		title: {
			text: 'Date'
		}
	}];


	hourlyTooltipFormatter = function() {
		var s = 'unknown';
		var beginHour = new Date(this.points[0].x);
		beginHour.setMinutes(0); // volle Stundenintervalle aber letzer Balken nher
		var endHour = new Date(beginHour);
		endHour.setHours(endHour.getHours() + 1);
		if(this.points.length == 2) {
			var series0Title = titles[this.points[0].series.name];
			var series1Title = titles[this.points[1].series.name];
			var totalTitle = titles['total'];
			
			s = '<b>' + Highcharts.dateFormat(dateFormat, beginHour)+
				'-'+Highcharts.dateFormat(dateFormat, endHour) +'</b><br/>'+		
				'<span style="color:'+this.points[0].series.color+'">'+series0Title+' ('+this.points[0].series.name+')</span>: '+ getValueAndUnit(Math.abs(this.points[0].y)) +'<br/>'+
				'<span style="color:'+this.points[1].series.color+'">'+series1Title+' ('+this.points[1].series.name+')</span>: '+ getValueAndUnit(Math.abs(this.points[1].y)) +'<br/>'+
				totalTitle+': '+ getValueAndUnit(Math.abs(this.points[0].y) + Math.abs(this.points[1].y)) +'<br/>';
		} else if(this.points.length == 1){
			var seriesTitle = titles[this.points[0].series.name];
//			s = '<b>' + Highcharts.dateFormat(dateFormat, this.points[0].x) +'</b><br/>'+
			s = '<b>' + Highcharts.dateFormat(dateFormat, beginHour)+
				'-'+Highcharts.dateFormat(dateFormat, endHour) +'</b><br/>'+
				'<span style="color:'+this.points[0].series.color+'">'+seriesTitle+' ('+this.points[0].series.name+')</span>: '+ getValueAndUnit(Math.abs(this.points[0].y)) +'<br/>';		
		}
		return s;
	};

	
	
/**
 * Fetch monthly, daily or hourly data from server
 * async!!
 */
function fetchData(dataServiceURL) {
	$.get(dataServiceURL, function(data) {
		// remove empty lines
		data = data.replace(/[\s\r\n]+$/, '');
		// Split the lines
		var lines = data.split('\n');

		var rxseries = {
			data: []
		};
		rxseries.name = "rx";
		
		var txseries = {
			data: []
		};
		txseries.name = "tx";

		var txseriesMinus = {
			data: []
		};
		txseriesMinus.name = "tx";
		
		// Iterate over the lines and add categories or series
		$.each(lines, function(lineNo, line) {
			
			var items = line.split(';');

			/*
				d;0;1078696800;559;7433;68;557;1
				0	d = days, m = months, t = top10
				1	0  =  day  number  in  database  (0  is  today),
				2	1077314401  date in Unix time, 
				3	559 = rx MiB, 
				4	7433 = tx MiB, 
				5	68 = rx KiB, 
				6	557 = tx KiB and 
				7	1 tells that vnStat has filled this value and it is in use.
					RX = Col 4 + (Col 5/1024) and TX = Col 5 + (Col 7/1024)
					
				h;0;1333151998;4468;3056
				0	h = hours, 
				1   0  =  hour  number  in  database  (0  is  this hour),
				2   1333151998 date in Unix time --> nicht aufsteigend sortiert!
				3   4468 = rx KiB 
				4   3056 = tx KiB
		*/
				//multiply unix time by 1000 to get miliseconds for highchart
				var range = items[0];
				var millisec = items[2] * 1000;
				var rx, tx;
				if(range == 'h') { //hours only have fields 3 and 4 in KiB
					rx = parseFloat(items[3]) * 1024;
					tx = parseFloat(items[4]) * 1024;
					var date = new Date(millisec);
					date.setMinutes(30); //Anzeige Intervall 16-17 bei 16:30
					millisec = date.getTime();
					//Different formatter to show correct hourly time interval
					barOptions.tooltip.formatter = hourlyTooltipFormatter;
				} else { //days, months and top10 have fields 3/4 in MiB plus fields 5/6 in KiB
					rx = parseFloat(items[3]) * 1024 * 1024 + parseFloat(items[5] * 1024);
					tx = parseFloat(items[4]) * 1024 * 1024 + parseFloat(items[6] * 1024);
				}

				if(millisec > 0) {
					rxseries.data.push(new Array(millisec, rx));
					txseriesMinus.data.push(new Array(millisec, -1*tx));
					txseries.data.push(new Array(millisec, tx));
				}
		});

		rxseries.data.sort(sortByKey);
		txseries.data.sort(sortByKey);
		txseriesMinus.data.sort(sortByKey);

		barOptions.series.push(rxseries);
		barOptions.series.push(txseries);

		negativeBarOptions.series.push(rxseries);
		negativeBarOptions.series.push(txseriesMinus);

		// Create the chart
//		var areaChart = new Highcharts.Chart(barOptions);
		var areaChart = new Highcharts.Chart(negativeBarOptions);
	});
}


/**
 * Fetch monthly, daily or hourly data from server
 * async!!
 */
function fetchTop10Data(dataServiceURL) {
	$.get(dataServiceURL, function(data) {
		// remove empty lines
		data = data.replace(/[\s\r\n]+$/, '');
		// Split the lines
		var lines = data.split('\n');

		var rxseries = {
			data: []
		};
		rxseries.name = "rx";
		
		var txseries = {
			data: []
		};
		txseries.name = "tx";

		var txseriesMinus = {
			data: []
		};
		txseriesMinus.name = "tx";
		
		var days = [];

		// Iterate over the lines and add categories or series
		$.each(lines, function(lineNo, line) {
			
			var items = line.split(';');

			/*
				h;0;1333151998;4468;3056
				d;0;1078696800;559;7433;68;557;1
				0	d = days, 
				1	0  =  day  number  in  database  (0  is  today),
				2	1077314401  date in Unix time, 
				3	559 = rx MiB, 
				4	7433 = tx MiB, 
				5	68 = rx KiB, 
				6	557 = tx KiB and 
				7	1 tells that vnStat has filled this value and it is in use.
					RX = Col 4 + (Col 5/1024) and TX = Col 5 + (Col 7/1024)
			*/
				//multiply unix time by 1000 to get miliseconds for highchart
				var rx = parseFloat(items[3]) * 1024 * 1024 + parseFloat(items[5] * 1024);
				var tx = parseFloat(items[4]) * 1024 * 1024 + parseFloat(items[6] * 1024);
				var millisec = items[2] * 1000;

				
				days.push(millisec);
				//lineNo als key damit man einfach nach Gesamttraffic sortieren kann
				// sortByKey --> Gesamttraffic, sortByValues --> RX/TX Traffic
				rxseries.data.push(new Array(lineNo, rx));
				txseriesMinus.data.push(new Array(lineNo, -1*tx));
				txseries.data.push(new Array(lineNo, tx));
		});

		barOptions.series.push(rxseries);
		barOptions.series.push(txseries);
		
		//set timestamp categories to calculate date in xAxis.labels.formatter
		barOptions.xAxis.categories = days;
		negativeBarOptions.xAxis[0].categories = days;
		negativeBarOptions.xAxis[1].categories = days;

		negativeBarOptions.series.push(rxseries);
		negativeBarOptions.series.push(txseriesMinus);

		// Create the chart
		var areaChart = new Highcharts.Chart(barOptions);
		var areaChart = new Highcharts.Chart(negativeBarOptions);
	});
}

/**
 * Fetch initial data points from server
 */
function initLiveValues(dataServiceURL) {
	$.ajax({
		url: dataServiceURL,
		success: function(data) {
			// remove empty lines
			data = data.replace(/[\s\r\n]+$/, '');
			var items = data.split(';');
			
			//set in chart title
//			ifaceName = items[0];
			//milliseconds
			var timestamp = parseInt(items[1]) * 1000;
			//Byte values!
			rxCircle.push(new Array(timestamp, parseFloat(items[2])));
			txCircle.push(new Array(timestamp, parseFloat(items[3])));
		},
		/* has to be async to wait until values have been 
		retrieved and initialized */
		async: false,
		cache: false
	});
}

/**
 * Request data from the server, add it to the graph and set 
 * a timeout to request again
 */
function updateLiveData() {
	$.ajax({
		url: dataServiceURL,
		success: function(data) {
		
			// remove empty lines
			data = data.replace(/[\s\r\n]+$/, '');
			var items = data.split(';');

			// interface;timestamp;traffInByte;traffOutByte;traffInKByte;traffOutKByte
			// eth0;1332020070;2929126867;2929126867;2860475.45;2860475.45

			updateLiveSeries(items); 
			
			// call it again after refreshFrequency
			setTimeout(updateLiveData, refreshFrequency);    
		},
		cache: false
	});
}

/**
 *
 */
function updateLiveSeries(items) {

	var timestamp = parseInt(items[1]);
	//multiply unix time by 1000 to get miliseconds for highchart
	var millisec = timestamp * 1000;
	//both values in Bytes
	var rx = parseFloat(items[2]);
	var tx = parseFloat(items[3]);
	
	var shift = chart.series[0].data.length > maxValueCount; // shift if the series is longer than maxValueCount

	var avgRates = getAVGRates(millisec, rx, tx);
	var currentRates = getCurrentRates(rxCircle[rxCircle.length-1][0], 
										rxCircle[rxCircle.length-1][1], 
										txCircle[txCircle.length-1][1], 
										millisec, 
										rx, 
										tx);

	// add data points (transmission rates)
	var redraw = true; //if false manually do chart.redraw()
	chart.series[0].addPoint(new Array(millisec, currentRates[0]), redraw, shift);
	chart.series[1].addPoint(new Array(millisec, -1*currentRates[1]), redraw, shift);
	chart.series[2].addPoint(new Array(millisec, avgRates[0]), redraw, shift);
	chart.series[3].addPoint(new Array(millisec, -1*avgRates[1]), redraw, shift);
	// Pie Chart avg RX/TX over the last maxValueCount values
	chart.series[4].setData(new Array(new Array('RX', rx-rxCircle[0][1]), 
										new Array('TX', tx-txCircle[0][1])));
	
	//store real rx and tx byte values
	rxCircle.push(new Array(millisec, rx));
	txCircle.push(new Array(millisec, tx));
	//ensure max array length
	reduceArray(rxCircle, maxValueCount);
	reduceArray(txCircle, maxValueCount);
}


/************** Rate Calculations **************/
/**
Calculate current input and output rates (deltas)
Inputs:
	t0time, t1time in Milliseconds
	t0rx, t0tx, t1rx, t1tx in Bytes
**/
function getCurrentRates(t0time, t0rx, t0tx, t1time, t1rx, t1tx) {
	var deltaTime = t1time - t0time + 500; /* milliseconds; +500 as	otherwise 
	we may get divide by 0 --> INFINIT rates --> no chart; 500 avg wait between init and first refresh */
	var deltaInBytes = t1rx - t0rx; //bytes
	var deltaOutBytes = t1tx - t0tx; //bytes
	var inRate = (deltaInBytes / deltaTime) * 1000; // bytes/second
	var outRate = (deltaOutBytes / deltaTime) * 1000; // bytes/second
	
	return new Array(inRate, outRate);
}

/**
Calculate average input and output rate since t0
inputs:
	timestamp in Milliseconds
	bytesIn, bytesOut in Bytes
**/
function getAVGRates(timestamp, bytesIn, bytesOut) {
	return getCurrentRates(rxCircle[0][0], rxCircle[0][1], txCircle[0][1], timestamp, bytesIn, bytesOut);
}



/************** Array Helpers **************/

/**
* reduce array to max size by removing entries from beginning
**/
function reduceArray(array, maxLength) {
	while(array.length > maxLength) {
		array.shift();
	}
}

/**
 * Sort key-value-array by keys
*/
function sortByKey(a, b) {
	return a[0] - b[0];
}

/**
 * Sort key-value-array by values
*/
function sortByValues(a, b) {
	return a[1] - b[1];
}


/************** Unit Conversion **************/
/**
* Calculate Unit and Value for a given byte number
**/
function getValueAndUnit(bytes) {
	if(bytes == 0) {
		return 0;
	} else {
		var unit = new Array("B", "KB", "MB", "GB", "TB", "PB");

		var abs = Math.abs(bytes);
		var log = Math.log(abs) / Math.log(1024);
		var index = Math.floor(log);
		var pow = Math.pow(1024, index);
		var value = Math.round((bytes / pow) * Math.pow(10, 2)) / Math.pow(10, 2);

		return value + unit[index];
	}
}


/************** Unit Conversion **************/
/**
* Calculate Unit and Value for a given byte number
**/
function getValueAndUnitArray(bytes) {
	vu = [];
	if(bytes == 0) {
		return new Array(0,null);
	} else {
		var unit = new Array("B", "KB", "MB", "GB", "TB", "PB");

		var abs = Math.abs(bytes);
		var log = Math.log(abs) / Math.log(1024);
		var index = Math.floor(log);
		var pow = Math.pow(1024, index);
		var value = Math.round((bytes / pow) * Math.pow(10, 2)) / Math.pow(10, 2);

		return new Array(value, unit[index]);
	}
}



/**
* Calculate Unit and Value for a given byte number
**/
/*
function getValueAndUnit(bytes, precision) {
	var unit = new Array("B", "KB", "MB", "GB", "TB", "PB");

	var abs = Math.abs(bytes);
	var log = Math.log(abs) / Math.log(1024);
	var index = Math.floor(log);
	var pow = Math.pow(1024, index);
//		var value = Math.round(bytes/pow, 2);
	var value = Math.round((bytes / pow) * Math.pow(10, precision)) / Math.pow(10, precision);

	return value + ' ' + unit[index];
}
*/


/************** Other **************/

/**
 * function for xAxis.labels.formater
 * calculates a date from the catogories entry and highlights it
 * if it is a Saturday or Sunday.
**/
function getHighlightedAxisLabels() {
	var label;
	var date = new Date(this.value);
	var day = date.getDay();
	if(day == 0 || day == 6) { //Sonntag oder Samstag
		label = '<span style="font-weight:bold;color:#B94C69">'+
		Highcharts.dateFormat(dateFormat, date)+
		'</span>';
	} else {
		label = Highcharts.dateFormat(dateFormat, date);
	}
	return label;
}
