#!/bin/sh
. /srv/www/include/cgi-helper

dataServiceBaseURL='../vnstat_dataservice.cgi'

update_text_output()
{
interface=$1
range=$2
case $range in
hours) vnstat_range="--hours" ;;
days) vnstat_range="--days" ;;
weeks) vnstat_range="--weeks" ;;
months) vnstat_range="--months" ;;
top10) vnstat_range="--top10" ;;
summary) vnstat_range="--short" ;;
*) vnstat_range="--days" ;;
esac
echo "<pre>"
vnstat -i $interface $vnstat_range
echo "</pre>"
}

load_js()
{
cat <<EOF
<script src="../js/jquery/jquery-1.7.1.min.js" type="text/javascript"></script>
<script src="../js/highstock.js" type="text/javascript"></script>
<script src="../js/exporting.js" type="text/javascript"></script>
<script src="../js/vnstat_helpers.js" type="text/javascript"></script>
EOF
}

# for wlan interfaces we additionally show the ESSID
get_interface_text()
{
interface=$1
  if [ -z `echo "$interface" |grep wlan` ]; then
    echo $interface
  else
    ESSID="";NICK="";FREQ="";MODE="";APMAC="";OWNMAC="";
    eval `iwconfig $interface |
    sed -n "s/.*\(ESSID\):\(\".*\"\).*Nickname:\(\".*\"\).*/\1=\2 ;NICK=\3/p
      s/.*\(Mode\):\(.*\).*Frequency:\(.*\) GHz.*.*Access Point: \(.*\)/\MODE=\2 ;FREQ=\3; APMAC=\4/p"`
            
    echo "$interface ($ESSID)"
   fi
}


show_current_data()
{
interface=$1
interface_name=$(get_interface_text $interface)

cat <<EOF
    <script type="text/javascript">
    var chart; // global
    
    var maxValueCount = 10; //
    var refreshFrequency = 1000; //ms
    var rxCircle = [], txCircle = [];
    var ifaceName = '$interface'
    var ifaceText = '$interface_name'
    var dataServiceURL = '$dataServiceBaseURL?interface=' + ifaceName + '&range=current';

    initLiveValues(dataServiceURL);
    
    \$(document).ready(function() {
        liveTrafficOptions.title.text = 'Live Traffic ' + ifaceText;
        chart = new Highcharts.Chart(liveTrafficOptions);        
    });
</script>

<div id="liveData" style="width: 800px; height: 400px; margin: 0 auto"></div>
EOF
}

# show hourly, daily and monthly data
show_data()
{
interface=$1
range=$2
interface_name=$(get_interface_text $interface)

case $range in
  hours)  dateformat='%H:%M';
          chartTitle="Hourly Traffic $interface_name";
  ;;
  days)   dateformat='%A, %d. %B %Y';
          chartTitle="Daily Traffic $interface_name";
  ;;
  months) dateformat='%B %Y';
          chartTitle="Monthly Traffic $interface_name";
  ;;
  *)      dateformat='%B %Y';
  ;;
esac

#escape special chars \$
cat <<EOF
<script type="text/javascript">
    var ifaceName = '$interface';
    var range = '$range';
    var dataServiceURL = '$dataServiceBaseURL?interface=' + ifaceName + '&range='+range;
    var dateFormat = '$dateformat';

    barOptions.title.text = '$chartTitle';
    negativeBarOptions.title.text = '$chartTitle';

    \$(document).ready(function() {
        fetchData(dataServiceURL);
    });
</script>

    <div id="barChart" style="width: 800px; height: 600px; margin: 0 auto"></div>
EOF
}

# show top10 days
show_top10_data()
{
interface=$1

dateformat='%A, %d.%m.%Y';
chartTitle="Top10 Traffic Days $interface";

#escape special chars \$
cat <<EOF
<script type="text/javascript">
    var ifaceName = '$interface';
    var range = '$range';
    var dataServiceURL = '$dataServiceBaseURL?interface=' + ifaceName + '&range='+range;
    var dateFormat = '$dateformat';

    barOptions.title.text = '$chartTitle';

    barOptions.xAxis.type = 'linear';
    //highlight weekends
    barOptions.xAxis.labels = {
        formatter: getHighlightedAxisLabels
    };

    \$(document).ready(function() {
        fetchTop10Data(dataServiceURL);
    });
</script>

    <div id="columnChart" style="width: 800px; height: 400px; margin: 0 auto"></div>
EOF
}


#########################################################################

# set default values for first access
if [ "$FORM_range" == "" ]; then
  FORM_range="current"
fi
if [ "$FORM_action" == "" ]; then
  FORM_action="eth0"
fi


show_html_header "vnStat"

load_js

# build subtabs but omit useless imq2-imq15 devices
allInterfaces=`vnstat --iflist | cut -d":" -f2 | sed 's/^[ ]*//' | sed 'y/ /\n/' | grep -v "^$" | grep -v "imq[1][0-9]" | grep -v "imq[2-9]"`
for availableInterface in $allInterfaces overview; do
  if [ $FORM_action = $availableInterface ]; then
    link="no"
  else
    link="${myname}?action=$availableInterface&range=$FORM_range"
  fi
  subtabs="${subtabs} \"$availableInterface\" \"${link}\""
done

#build table of all interfaces
eval "show_tab_header $subtabs"
case $FORM_action in
  overview) echo "<pre>"
            vnstat -q
            echo "</pre>"
            ;;
  *)
      subtabs=""
      for range in current hours days months top10; do
        if [ $FORM_range = $range ]; then
          link="no"
        else
          link="${myname}?action=$FORM_action&range=$range"
        fi
        subtabs="${subtabs} \"$range\" \"${link}\""
      done
      eval "show_tab_header $subtabs"
      ;;
esac

# output selected data for chosen interface
case $FORM_range in
  current)  show_current_data $FORM_action  #DONE 
  ;;
  hours) show_data $FORM_action hours  #DONE
  ;;
  days) show_data $FORM_action days  #DONE
  ;;
  months) show_data $FORM_action months  #DONE
  ;;
  top10) show_top10_data $FORM_action  #DONE
  ;;
  *) update_text_output $FORM_action hours
  ;;
esac

show_tab_footer
show_tab_footer
show_html_footer
