#! /bin/sh
if [ "$1" = "" -o "$1" = "-h" -o "$2" = "-h" ]
then
echo "Sucht den Namen zu einer Telefonnummer, indem die Rckwrtssuche von"
echo " www.dasoertliche.de aufgerufen wird. Das dauert einen Moment."
echo ""
echo "Ein zweites Argument (nach der Telephonnummer) hat folgende Wirkung:"
echo "-a    Gibt auch die Adresse zurck (mehrzeilig)."
echo "-az   Gibt auch die Adresse zurck, aber in einer (entsprechend langen) Zeile."
echo "      z.B.     Mustermann Hans|Blumenstr. 1, 98763 Haushausen|(0 12) 34 56 78|"
echo "-azh  Gibt Name und Adresse im HTML-Format mit GoogleMaps-Link zurck."
echo ""
echo "Rckgabe:"
echo "Der Fehlercode 1 bedeutet, da auf die Anfrage bei www.dasoertliche.de eine"
echo "Antwort kam, die aber keinen oder mehrere Datenstze enthielt. In diesem Fall"
echo "ist eine erneute Suche nach derselben Telefonnummer aussichtslos."
echo "Der Fehlercode 2 bedeutet, da bei Anfrage bei www.dasoertliche.de ein"
echo "Verbindungsfehler aufgetreten ist, oder die Antwort von diesem Script nicht zu"
echo "interpretieren war. Eventuell kann man zu einem spteren Zeitpunkt erfolgreich"
echo "suchen."
fi
nummer="$1"
telefonnummer=$(echo "$nummer" | sed -e 's/[^1234567890+]//g;s/^+/00/;s/^0049/0/;s/+//g' )
if [ "`echo "$telefonnummer" | cut -b -3`" = "017" ] ; then echo "Nach Nummern mit Handyvorwahl wird nicht gesucht!" >&2 ; exit 1 ; fi
if [ "`echo "$telefonnummer" | cut -b -3`" = "016" ] ; then echo "Nach Nummern mit Handyvorwahl wird nicht gesucht!" >&2 ; exit 1 ; fi
if [ "`echo "$telefonnummer" | cut -b -3`" = "015" ] ; then echo "Nach Nummern mit Handyvorwahl wird nicht gesucht!" >&2 ; exit 1 ; fi
if [ "`echo "$telefonnummer" | cut -b -3`" = "019" ] ; then echo "Nach Sonderrufnummern wird nicht gesucht!" >&2 ; exit 1 ; fi
tmpfile=/tmp/phonebook.antwort-$$
# echo -e "GET /Controller?form_name=search_inv&buc=&kgs=&zbuab=&page=5&context=4&action=43&ph=$telefonnummer&image=Finden  HTTP/1.0\nHost: www2.dasoertliche.de\nUser-Agent:Lynx/2.8.5\n\n" | netcat -w7 www.dasoertliche.de 80 > $tmpfile
echo -e "GET /?kw=$telefonnummer&s=a20000&cmd=search&ort_ok=0&sp=3&vert_ok=0&aktion=23 HTTP/1.0\nHost: www.dastelefonbuch.de\nUser-Agent:Lynx/2.8.5\n\n" | netcat -w7 www.dastelefonbuch.de 80 > $tmpfile
if [ "$?" != "0" ] 
then
echo "Fehler bei der Suchanfrage (Netzwerk? Server?)!" >&2
exit 2
fi

nbData=$( grep -c "id=\"name0\"" "$tmpfile" )
if [ "$nbData" != "1" ] 
then
echo "Fr diese Nummer wurde von 'das Oertliche' kein oder mehrere Teilnehmer gefunden!" >&2
exit 1
fi
grep "id=\"name0\"" $tmpfile | sed -e "s/.*title=\"\([^\"]*\)\".*/\1/" >/tmp/phonebook.antselect-$$
zn=$( grep -n "address class=\"popupMenuTrigger\"" $tmpfile | sed -e "s/:.*//")
zn=$(expr $zn + 1)
tail -n +$zn $tmpfile | head -n 1 | sed -e "s/<span itemprop=\"locality\">//" | sed -r "s/<\/span.*//" | sed -e "s/^\t//" | sed -e "s/^ *//" | sed -e "s/,  /, /" >/tmp/phonebook.adr-$$
rm $tmpfile
zeilen=$( grep -c "" /tmp/phonebook.antselect-$$ )
if [ "$zeilen" -ge "20" ]
then
echo "Fr diese Nummer wurde von 'das Oertliche' offenbar mehrere Teilnehmer gefunden! ($zeilen)" >&2
# rm /tmp/phonebook.antselect-$$
exit 1
fi
case "$2" in
"-azh") 
zwischen=$( echo "$antwort" | sed "s#</a># | #;s/entry\">/>|#|/g;s/^[^<]*>//;s/<[^>]*>//g;s/&nbsp;/ /g;s/ */ /g;s/^ */|/" | tr -d "\n\r\t"| sed "s/^|#|//;s/|#|/<br>/g;s/ *|[| ]*/|/g;s/^|//" )
adresseHTML=$( echo "$zwischen" | cut -d "|" -f 2 | sed "s/ /+/g;s//%C3%A4/g;s//%C3%84/g;s//%C3%B6/g;s//%C3%96/g;s//%C3%BC/g;s//%C3%9C/g;s//%C3%9F/g;s/&nbsp;/ /g;s/ */ /g;s/^ //;s/ $//" )
linkHTML=$( echo "http://maps.google.de/maps?f=q\&hl=de\&q=$adresseHTML\&btnG=Adressen+suchen" )
zwischen2=$( echo "$zwischen" | sed "s//\&auml;/g;s//\&Auml;/g;s//\&ouml;/g;s//\&Ouml;/g;s//\&uuml;/g;s//\&uuml;/g;s//\&szlig;/g;" )
name=$( echo "$zwischen2" | sed "s#\([^|]*\)|\([^|]*\)|\(.*\)\$#<b>\1</b> <a href=\"$linkHTML\">\2</a> \3#;s/|/ \&nbsp; /g" )
;;
"-az") 
name=$( echo "$antwort" | sed "s#</a># | #;s/^[^<]*>//;s/<[^>]*>//g;s/&nbsp;/ /g;s/ */ /g;s/^ */|/" | tr -d "\n\r\t" | sed "s/ *|[| ]*/|/g;s/^|//" ) ;;
"-a") 
name=$( echo "$antwort"| sed "s#</a>##;s/^[^<]*>//;s/<[^>]*>//g;s/&nbsp;/ /g;s/ */ /g;s/^ */|/" | tr -d "\t" | sed "s/ *|[| ]*/|/g;s/^|//;/^[ ]*$/d" ) ;;
"") 
name=$( cat /tmp/phonebook.antselect-$$)", "$(cat /tmp/phonebook.adr-$$);;
*)
esac
rm /tmp/phonebook.antselect-$$
rm /tmp/phonebook.adr-$$
if [ "$name" = "" ]
then
echo "Die Antwort von 'das Oertliche' konnte von diesem Script nicht interpretiert werden. Serverfehler oder Scriptfehler!" >&2
exit 2;
else
echo "$name"
fi
