#! /bin/sh
#-----------------------------------------------------------------------------
# /usr/local/bin/phonebooksearch.sh - opt_phonebook                   3.0.2
#
# Modifikation:     30.12.2008 jk
# Version:      2.7.7
#-----------------------------------------------------------------------------


# Laden der config
. /var/run/phonebook.conf

if [ "$PHONEBOOK_DO_DEBUG" = "yes" ] ; then
   echo "`date "+%d.%m.%Y %T":` phonebooksearch.sh incoming Call from $1" >> $PHONEBOOK_LOG
fi
# setzen der Telefonummer als Variable
telefonnummer=$1

# berprfen, ob die Nummer im Phonebook auffindbar ist
name0="`grep ^$telefonnummer /etc/phonebook | sed -n 1p | cut -d= -f2 | sed -e 's/ /%20/g' `"
# Entfernen der 0 von einer Telefonanlage
if [ "$PHONEBOOKSEARCH_ADVANCE" = "yes" ] ; then
   #Sicherheitsueberpruefung dass wirklich eine zusaetzliche 0 durch Telefonanlage hinzugefuegt wurde
   if [ "`echo "$1" | cut -b-2`" = "00" ] ; then
     telefonnummer=`echo "$1" | cut -b2-`
     if [ "$PHONEBOOK_DO_DEBUG" = "yes" ] ; then
       echo "`date "+%d.%m.%Y %T":` phonebooksearch.sh Advance option set YES: $1 convert to $telefonnummer" >> $PHONEBOOK_LOG
     fi
   fi
fi

 # Wenn Nummer nicht im Phonebook gefunden wurde...
if [ -z "$name0" ]
then
  #... Dialmode setzen fuer Suche im Internet
  if [ "$PHONEBOOKSEARCH_DIALAUTO" = "yes" ]
  then
    dialmode=""
    case $( { echo "dialmode"; echo "quit"; } | netcat localhost 5000 | cut -b4-6 ) in
    "off") dialmode="off" ;;
    "aut") dialmode="auto" ;;
    "man") dialmode="manual" ;;
    *) echo "$( date "+%d.%m.%Y %T": ) phonebooksearch.sh unbekannter Dialmode!" >&2; exit 2 ;;
    esac
    if [ "$( { echo "dialmode"; echo "quit"; } | netcat localhost 5000 | cut -b4-6 )" != "aut" ]
    then
      echo "$( date "+%d.%m.%Y %T": ) Konnte Dialmode nicht korrekt setzen!" >&2
      echo "Konnte Dialmode nicht korrekt setzen!"  >&2
      exit 2
    fi
  fi
 
 #if [ "$PHONEBOOK_DO_DEBUG" = "yes" ]
  #then
  echo "`date "+%d.%m.%Y %T": ` phonebooksearch.sh sucht in Internet Name zu '$telefonnummer'" >> $PHONEBOOK_LOG
 #fi
  if [ "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" = "-az" ] ; then style="-"; fi
  if [ "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" = "-azh" ] ; then style="-"; fi

 #Hier wird die eigentliche Suche durchgefuehrt
  if [ "$style" != "-" ]
  then name1=$( phonebookInetSearch.sh "$telefonnummer" 2> /tmp/phonebook.error-$$ )
  else name1=$( phonebookInetSearch.sh "$telefonnummer" "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" 2> /tmp/phonebook.error-$$ )
  fi
  fehler="$?"
 # Fehler 1 = Keine Teilnehmer oder nicht eindeutig
 # Fehler 2 = Verbindungsfehler
  if [ "$fehler" != "0" ]
  then
    name1=""
    echo $( cat /tmp/phonebook.error-$$ ) >&2
    echo "`date "+%d.%m.%Y %T":` phonebooksearch.sh empfngt Fehler von phonebookInetSearch.sh: $( cat /tmp/phonebook.error-$$ )" >> $PHONEBOOK_LOG
  fi
  rm /tmp/phonebook.error-$$
 
 # Dialmode zurcksetzen
  if [ "$PHONEBOOKSEARCH_DIALAUTO" = "yes" ]
  then
    { echo "dialmode $dialmode"; echo "quit"; } | netcat localhost 5000
    echo "$( date "+%d.%m.%Y %T": ) phonebooksearch.sh Change dialmode to $dialmode" >> $PHONEBOOK_LOG
  fi

 # Die 0 der Telefonanlage wieder mit in das Telefonbuch schreiben, damit die Namenserkennung auch dann weiter luft
  if [ "$PHONEBOOKSEARCH_ADVANCE" = "yes" ]
  then telefonnummer=$1
  fi
 
 #nurnummer soll wirklich nur die Ziffern der Telephonnummer enthalten, wie sie auch von der ISDN Software spter gemeldet werden.
  nurnummer=$( echo "$telefonnummer" | sed -e 's/[^1234567890+]//g;s/^+49/0/;s/^+/00/;s/+//g' )
 #Kommata in Semikola verwandeln, falls erwnscht
  if [ "$PHONEBOOKSEARCH_SEMIKOLON" = "yes" ]
  then name1=$( echo $name1 | sed "s/,/;/g" )
  fi
 # berprfen, ob die Suche was gebracht hat, wenn ja, dann auch ins Telefonbuch eintragen
  if [ "$name1" !=  "" ]
  then
  #Nummer eintragen
    if [ "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" != ""  ]
    then
      if [ "$style" != "-" ]
      then echoname=$(echo "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" | sed -e 's/NAME/'"$name1"'/g' | sed -e 's/NUMMER/'$telefonnummer'/g')
      else echoname="$name1"
      fi
    else
      if [ "$PHONEBOOKSEARCH_ADDNUMBER" = "yes" ] #Bedeutet: auer dem Namen noch die Nummer eintragen
      then echoname="$name1 [$telefonnummer]"
      else echoname="$name1"
      fi
    fi
    echo "$nurnummer=$echoname" | sed 's/= /=/' >> /etc/phonebook
    echo "Fge Zeile ein: $nurnummer=$echoname" >> $PHONEBOOK_LOG
  else
    # Wenn PHONEBOOKSEARCH_AGAIN = no, Sperreintrag setzen, der verhindert, da die Nummer erneut gesucht wird.
    # Wenn nur der HTTP-Error vorlag, dann doch kein Sperreintrag
    if [ "$fehler" != "2" -a "$PHONEBOOKSEARCH_AGAIN" != "yes" ]
    then 
      echo "$nurnummer=$telefonnummer (Kein Teilnehmer gefunden)" | sed 's/= */=/' >> /etc/phonebook
    fi
  fi
fi
