#!/bin/bash
#-----------------------------------------------------------------------------
# /usr/local/bin/phonebookrefresh.sh - opt_phonebook              __FLI4LVER__
#
# Creation:     20.06.2007 jk
# Last Update:  $Id: phonebookrefresh.sh 19583 2011-05-01 12:14:35Z arwin $
#-----------------------------------------------------------------------------

. /var/run/phonebook.conf
DATEI=/etc/phonebook

if [ -f $DATEI ]
then
 if [ -f /etc/phonebook.new-$$ ] ; then rm /etc/phonebook.new-$$; fi

 while read LINE; do
  #read LINE kann die nchste zeile lesen
  
  #berprfe ob es keine Handy bzw Sonderrufnummer ist
  NumKurz=$( echo $LINE | cut -b -3)
  sonder="0"
  if [ "$NumKurz" = "015" ] ; then sonder="1"; fi
  if [ "$NumKurz" = "016" ] ; then sonder="1"; fi
  if [ "$NumKurz" = "017" ] ; then sonder="1"; fi
  if [ "$NumKurz" = "018" ] ; then sonder="1"; fi
  if [ "$NumKurz" = "019" ] ; then sonder="1"; fi
  # brprfe ob auch eine Nummer in der Zeile steht
  
  if [ "$( echo $LINE | grep '^0=')" != "" ] ; then sonder="1"; fi
  if [ "$( echo $LINE | grep '^00=')" != "" ] ; then sonder="1"; fi
  if [ "$( echo $LINE | grep '^[1-9]')" != "" ] ; then sonder="1"; fi
  if [ "$( echo $LINE | grep '^[0-9]')" = "" ] ; then sonder="2"; fi
  
  if [ "$sonder" != "0" ]
  then
   #bernehme Orginal Zeile
    if [ "$sonder" = "1" ]
    then
     echo "$LINE" >>/etc/phonebook.new-$$
    fi
 
    if [ "$sonder" = "2" ]
    then
     if [ "$1" != "-le" ]
     then
      echo "$LINE" >>/etc/phonebook.new-$$
     fi
    fi
  else
  
   #schneide alles nach der nummer ab
   Nummer=$( echo "$LINE" | cut -d= -f1 )
  
   #Suche $Nummer nun bei das rtliche
   #ergeniss=$( /usr/local/bin/phonebookInetSearch.sh $Nummer )
 
   if [ "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" = "-az" ] ; then style="-"; fi
   if [ "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" = "-azh" ] ; then style="-"; fi
   if [ "$style" != "-" ]
   then
    name1=$( phonebookInetSearch.sh "$Nummer" 2> /tmp/phonebook.error-$$ )
   else
    name1=$( phonebookInetSearch.sh "$Nummer" "$PHONEBOOKSEARCH_ADDNUMBERSTYLE" 2> /tmp/phonebook.error-$$ )
   fi
 
   #Eintr�e ins Phonebook bernehmen
   if [ "$?" = "0" ]
   then
    if [ "$PHONEBOOKSEARCH_SEMIKOLON" = "yes" ]
     then name1=$( echo $name1 | sed "s/,/;/g" )
    fi
    echo "$Nummer=$name1" >>/etc/phonebook.new-$$
   else
    echo "$LINE" >>/etc/phonebook.new-$$
    echo $( cat /tmp/phonebook.error-$$ ) >&2
   fi
  fi
 
 done < $DATEI
 
 if [ -f /etc/phonebook.new-$$ ]
 then
  rm /etc/phonebook
  cp /etc/phonebook.new-$$ /etc/phonebook
 fi
 
 if [ -f /etc/phonebook.new-$$ ] ; then rm /etc/phonebook.new-$$; fi
 
else
 echo "Die Datei '$DATEI' ist nicht vorhanden!"
fi