#!/bin/sh
##-----------------------------------------------------------------------------
## interface.txt - fli4l documentation
##
## keine Haftung !!
## Nutzung auf eigene Gefahr
##
## Last Update:  $Id: interface.txt 2012-08-03 demlak $ 
##
## Copyright (c) 2012 demlak
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------
##
# interface check -> execute
# -----------
# time to sleep between each status check in microseconds
# 0,5s = 500000s
pause="300000"

# commands to execute when status on pin = 1
execute_1="echo "blahfasel_1""
execute_2="echo "blahfasel_2""
execute_3="echo "blahfasel_3""
execute_4="echo "blahfasel_4""
execute_5="echo "blahfasel_5""

# reset all 'memories'
for idreset in `seq 1 5`
 do
   eval bit_${idreset}="0"
 done

while true                                               # loop this:
 do
   for idstatus in `seq 1 5`                             # loop through each pin:
    do
     if [ `lptkeys -p 0 -f | cut -c ${idstatus}` = "1" ] # check if pin is "1"
        then
           if eval [ \$bit_${idstatus} = "0" ]           # if pin is "1"
              then eval \$execute_${idstatus}            # then execute command
              eval bit_${idstatus}="1"                   # and set memory to "1"
           fi
        else
        eval bit_${idstatus}=0                           # else set memory to "0"
     fi
   done
  usleep ${pause}                                        # let loop sleep for given microseconds
 done