#!/bin/sh
##-----------------------------------------------------------------------------
## interface.txt - fli4l documentation
##
## keine Haftung !!
## Nutzung auf eigene Gefahr
##
## Last Update:  $Id: interface.txt 2012-08-03 demlak $
##
## Copyright (c) 2012 demlak
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------
##
# interface check -> execute
# -----------
# time to sleep between each status check in microseconds
# 0,5s = 500000 microseconds
pause="300000"

# commands to execute when status on pin = 1
execute_0_1="echo "blahfasel_0_1""

# get config variables
. /var/run/interface.cfg


# reset all 'memories'
for idresetall in `seq 1 $INTERFACE_PORT_N`
do 
eval 'port=$INTERFACE_PORT_'$idresetall''
for idresetport in `seq 1 5`
 do
    eval bit_${port}_${idresetport}="0"
 done
done

# check loop
while true  # loop forever
 do
   for idport in `seq 1 $INTERFACE_PORT_N`  # loop through ports
    do
     eval 'port=$INTERFACE_PORT_'$idport''  # evaluate port
     for idstatus in `seq 1 5`  # loop through each pin:
      do
       if [ `lptkeys -p $port -f | cut -c ${idstatus}` = "1" ]  # check if pin is "1"
          then
              if eval [ \$bit_${port}_${idstatus} = "0" ]  # if pin is "1"
                 then eval \$INTERFACE_${idport}_IN_DEV_${idstatus}_EXEC  # get command and execute
                      eval bit_${port}_${idstatus}="1"  # and set memory to "1"
                      eval echo \$bit_${port}_${idstatus} > /var/run/interface_${port}_${idstatus}  # write memory to file
              fi
          else eval bit_${port}_${idstatus}="0"  # else set memory to "0"
               eval echo \$bit_${port}_${idstatus} > /var/run/interface_${port}_${idstatus}  # write memory to file
       fi
      done
      usleep ${pause} # let loop sleep for given microseco
    done
 done
 